/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.client.screen;

import com.tyzsskills.Config;
import com.tyzsskills.client.ClientCache;
import java.util.Locale;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

public class XpTriggerOverlay
implements LayeredDraw.Layer {
    private static float accumulatedXp = 0.0f;
    private static long lastUpdateTime = 0L;
    private static long appearanceTime = 0L;
    private static final long fadeIn = 300L;
    private static final long fadeOut = 500L;
    private static final float SCALE = 0.5f;
    private static final int MARGIN = 4;

    public static void AddXp(float amount) {
        long duration;
        boolean isActive;
        if (!((Boolean)Config.SHOW_XP_OVERLAY.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        if (mc.player.isCreative() && !((Boolean)Config.SHOW_OVERLAYS_IN_CREATIVE.get()).booleanValue()) {
            return;
        }
        long now = System.currentTimeMillis();
        boolean bl = isActive = now - lastUpdateTime < (duration = (long)((Double)Config.XP_DURATION.get() * 1000.0)) && accumulatedXp > 0.0f;
        if (!isActive) {
            accumulatedXp = amount;
            appearanceTime = now;
        } else {
            accumulatedXp += amount;
        }
        lastUpdateTime = now;
    }

    public static void Clear() {
        accumulatedXp = 0.0f;
        lastUpdateTime = 0L;
        appearanceTime = 0L;
    }

    public void render(GuiGraphics gui, DeltaTracker deltaTracker) {
        long duration;
        long now = System.currentTimeMillis();
        long timeSinceUpdate = now - lastUpdateTime;
        if (timeSinceUpdate > (duration = (long)((Double)Config.XP_DURATION.get() * 1000.0)) || accumulatedXp <= 0.0f) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        long timeSinceAppearance = now - appearanceTime;
        float alpha = 1.0f;
        float yOffset = 0.0f;
        if (timeSinceAppearance < 300L) {
            float progress = (float)timeSinceAppearance / 300.0f;
            alpha = progress = (float)Math.sin((double)progress * Math.PI / 2.0);
            yOffset = (1.0f - progress) * 20.0f;
        } else if (timeSinceUpdate > duration - 500L) {
            alpha = (float)(duration - timeSinceUpdate) / 500.0f;
        }
        alpha = Mth.clamp((float)alpha, (float)0.0f, (float)1.0f);
        if (alpha <= 0.05f) {
            return;
        }
        int cfgBg = ClientCache.ParseColor((String)Config.XP_BG_COLOR.get(), -1442840576);
        int cfgBorder = ClientCache.ParseColor((String)Config.XP_BD_COLOR.get(), -1);
        int cfgText = ClientCache.ParseColor((String)Config.XP_TEXT_COLOR.get(), -1);
        String amountStr = accumulatedXp == (float)((long)accumulatedXp) ? String.format("%d", (long)accumulatedXp) : String.format(Locale.US, "%.1f", Float.valueOf(accumulatedXp));
        MutableComponent text = Component.literal((String)("+ " + amountStr + " ")).append((Component)Component.translatable((String)"gui.tyzs_skills.xp"));
        int textWidth = font.width((FormattedText)text);
        int padding = 6;
        int height = 12 + padding * 2;
        int width = textWidth + padding * 2;
        gui.pose().pushPose();
        gui.pose().scale(0.5f, 0.5f, 1.0f);
        int x = 8;
        int scaledScreenHeight = (int)((float)screenHeight / 0.5f);
        int y = scaledScreenHeight - height - 8;
        x += (int)((float)((Integer)Config.XP_OFFSET_X.get()).intValue() / 0.5f);
        y -= (int)((float)((Integer)Config.XP_OFFSET_Y.get()).intValue() / 0.5f);
        y += (int)yOffset;
        int bgBaseAlpha = cfgBg >> 24 & 0xFF;
        int bgFinalAlpha = (int)((float)bgBaseAlpha * alpha);
        int bgFinal = bgFinalAlpha << 24 | cfgBg & 0xFFFFFF;
        int borderBaseAlpha = cfgBorder >> 24 & 0xFF;
        int borderFinalAlpha = (int)((float)borderBaseAlpha * alpha);
        int borderFinal = borderFinalAlpha << 24 | cfgBorder & 0xFFFFFF;
        int textBaseAlpha = cfgText >> 24 & 0xFF;
        int textFinalAlpha = (int)((float)textBaseAlpha * alpha);
        int textFinal = textFinalAlpha << 24 | cfgText & 0xFFFFFF;
        this.renderTooltipStyleRect(gui, x, y, width, height, bgFinal);
        this.renderTooltipStyleBorder(gui, x, y, width, height, borderFinal);
        gui.drawString(font, (Component)text, x + padding, y + padding + 2, textFinal, true);
        gui.pose().popPose();
    }

    private void renderTooltipStyleRect(GuiGraphics gui, int x, int y, int width, int height, int color) {
        gui.fill(x, y + 1, x + width, y + height - 1, color);
        gui.fill(x + 1, y, x + width - 1, y + 1, color);
        gui.fill(x + 1, y + height - 1, x + width - 1, y + height, color);
    }

    private void renderTooltipStyleBorder(GuiGraphics gui, int x, int y, int width, int height, int color) {
        gui.fill(x + 1, y, x + width - 1, y + 1, color);
        gui.fill(x + 1, y + height - 1, x + width - 1, y + height, color);
        gui.fill(x, y + 1, x + 1, y + height - 1, color);
        gui.fill(x + width - 1, y + 1, x + width, y + height - 1, color);
    }
}

