/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.active;

import com.tyzsskills.Config;
import com.tyzsskills.server.active.LevelManager;
import com.tyzsskills.server.active.PowerManager;
import com.tyzsskills.server.active.SpManager;
import com.tyzsskills.server.attachments.StatsTracker;
import com.tyzsskills.server.model.Skill;
import com.tyzsskills.server.payloads.ConfigSyncPayload;
import com.tyzsskills.server.payloads.LevelDataUpdatePayload;
import com.tyzsskills.server.payloads.LevelUpdatePayload;
import com.tyzsskills.server.payloads.PowerUpdatePayload;
import com.tyzsskills.server.payloads.SkillBookmarksPayload;
import com.tyzsskills.server.payloads.SkillLevelSyncPayload;
import com.tyzsskills.server.payloads.SkillSyncPayload;
import com.tyzsskills.server.payloads.SpUpdatePayload;
import com.tyzsskills.server.payloads.StatsSpEarnedPayload;
import com.tyzsskills.server.payloads.StatsSpSpentPayload;
import com.tyzsskills.server.payloads.StatsXpPayload;
import com.tyzsskills.server.payloads.XpUpdatePayload;
import com.tyzsskills.server.skills.SkillManager;
import com.tyzsskills.server.xp.XpManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;

public class AutoSyncClient {
    public static void SyncSkillList(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SkillSyncPayload(SkillManager.Get().GetAllSkills()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void SyncSkillLevels(ServerPlayer player) {
        for (Skill skill : SkillManager.Get().GetAllSkills()) {
            String key;
            CompoundTag data = player.getPersistentData();
            int lvl = data.getInt(key = skill.GetID().toLowerCase() + "_lvl");
            if (lvl <= 0) continue;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SkillLevelSyncPayload(skill.GetID(), lvl), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void SyncSkillBookmarks(ServerPlayer player) {
        for (Skill skill : SkillManager.Get().GetAllSkills()) {
            String key;
            CompoundTag data = player.getPersistentData();
            if (!data.getBoolean(key = skill.GetID().toLowerCase() + "_bookmark")) continue;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SkillBookmarksPayload(skill.GetID().toLowerCase(), true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void SyncConfig(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ConfigSyncPayload((Boolean)Config.REFUND_SYSTEM.get(), (Double)Config.REFUND_PERCENTAGE.get(), (Integer)Config.TRAIT_UNLOCK_LEVEL.get(), (Boolean)Config.TRAIT_SYSTEM.get()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void SyncMainData(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new XpUpdatePayload(XpManager.GetXP(player), 0.0f), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new LevelUpdatePayload(LevelManager.GetLevel(player)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SpUpdatePayload(SpManager.GetSP(player)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new LevelDataUpdatePayload(XpManager.GetLevelData(LevelManager.GetLevel(player))), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PowerUpdatePayload(PowerManager.GetPower(player)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void SyncStats(ServerPlayer player) {
        StatsTracker data = (StatsTracker)player.getData(StatsTracker.DATA);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new StatsXpPayload(data.getAllTimeXp()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new StatsSpEarnedPayload(data.getTotalSpEarned()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new StatsSpSpentPayload(data.getTotalSpSpent()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

