/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.active;

import com.tyzsskills.server.active.LevelManager;
import com.tyzsskills.server.active.SpManager;
import com.tyzsskills.server.attachments.LegacyData;
import com.tyzsskills.server.attachments.StatsTracker;
import com.tyzsskills.server.skills.SkillManager;
import com.tyzsskills.server.xp.XpManager;
import java.util.Locale;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.neoforge.common.NeoForgeMod;

public class CompatibilityManager {
    private static final String MIGRATION_TAG = "tyzs_migrated_v1";

    public static void ProcessMigration(ServerPlayer player) {
        double oldGains;
        double oldEarns;
        double oldSp;
        double oldXp;
        if (player.getPersistentData().getBoolean(MIGRATION_TAG)) {
            return;
        }
        LegacyData legacy = (LegacyData)player.getData(LegacyData.PLAYER_VARIABLES);
        if (!legacy.hasData()) {
            player.getPersistentData().putBoolean(MIGRATION_TAG, true);
            return;
        }
        double oldLevel = legacy.getOldValue("Level");
        if (oldLevel > 1.0) {
            LevelManager.SetLevel(player, (int)oldLevel);
        }
        if ((oldXp = legacy.getOldValue("Skill_XP")) > 0.0) {
            XpManager.SetXP(player, (float)oldXp);
        }
        if ((oldSp = legacy.getOldValue("researchpoints")) > 0.0) {
            SpManager.SetSP(player, (int)oldSp);
        }
        StatsTracker data = (StatsTracker)player.getData(StatsTracker.DATA);
        double oldLifeTimeXp = legacy.getOldValue("lifetime_xp");
        if (oldLifeTimeXp > 0.0) {
            data.addXp((float)oldLifeTimeXp);
        }
        if ((oldEarns = legacy.getOldValue("earned_points")) > 0.0) {
            data.addSpEarned((int)oldEarns);
        }
        if ((oldGains = legacy.getOldValue("spent_points")) > 0.0) {
            data.addSpSpent((int)oldGains);
        }
        CompatibilityManager.RemoveOldModifier(player, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, "speedmodifier");
        CompatibilityManager.RemoveOldModifier(player, (Holder<Attribute>)Attributes.OXYGEN_BONUS, "OxygeneModifier");
        CompatibilityManager.RemoveOldModifier(player, (Holder<Attribute>)Attributes.ATTACK_DAMAGE, "AttackDamageModifer");
        CompatibilityManager.RemoveOldModifier(player, (Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE, "ReachModifer");
        CompatibilityManager.RemoveOldModifier(player, (Holder<Attribute>)Attributes.MAX_HEALTH, "HealthModifer");
        CompatibilityManager.RemoveOldModifier(player, (Holder<Attribute>)Attributes.SNEAKING_SPEED, "sneakingModifier");
        CompatibilityManager.RemoveOldModifier(player, (Holder<Attribute>)Attributes.STEP_HEIGHT, "StepModifier");
        CompatibilityManager.RemoveOldModifier(player, (Holder<Attribute>)Attributes.MINING_EFFICIENCY, "MiningModifer");
        CompatibilityManager.RemoveOldModifier(player, (Holder<Attribute>)NeoForgeMod.SWIM_SPEED, "SwimModifer");
        CompatibilityManager.MigrateSkill(player, legacy, "block_reach_lvl", "block_reach");
        CompatibilityManager.MigrateSkill(player, legacy, "attack_damage_lvl", "attack_damage");
        CompatibilityManager.MigrateSkill(player, legacy, "max_health_lvl", "health_boost");
        CompatibilityManager.MigrateSkill(player, legacy, "venomous_attack_lvl", "venomous_attack");
        CompatibilityManager.MigrateSkill(player, legacy, "xp_boost_lvl", "experience_boost");
        CompatibilityManager.MigrateSkill(player, legacy, "damage_deal_lvl", "damage_deal");
        CompatibilityManager.MigrateSkill(player, legacy, "resistance_lvl", "resistance");
        CompatibilityManager.MigrateSkill(player, legacy, "skill_xp_boost_lvl", "swift_learn");
        CompatibilityManager.MigrateSkill(player, legacy, "critical_hit_lvl", "critical_hit");
        CompatibilityManager.MigrateSkill(player, legacy, "restaured_hunger_lvl", "nutrition");
        CompatibilityManager.MigrateSkill(player, legacy, "swim_speed", "swim_speed");
        CompatibilityManager.MigrateSkill(player, legacy, "speed_lvl", "speed_boost");
        CompatibilityManager.MigrateSkill(player, legacy, "step_height_lvl", "step_height");
        CompatibilityManager.MigrateSkill(player, legacy, "bloodlust_lv", "bloodlust");
        CompatibilityManager.MigrateSkill(player, legacy, "oxygene_boost_lvl", "oxygen_boost");
        CompatibilityManager.MigrateSkill(player, legacy, "mining_speed_level", "excavation");
        CompatibilityManager.MigrateSkill(player, legacy, "adrenaline_lvl", "adrenaline");
        CompatibilityManager.MigrateSkill(player, legacy, "sneaking_speed_lvl", "sneak_speed");
        int totalRefund = 0;
        totalRefund += CompatibilityManager.CheckRefund(legacy, "second_life_lvl", 20);
        totalRefund += CompatibilityManager.CheckRefund(legacy, "Villager_follow_lvl", 12);
        totalRefund += CompatibilityManager.CheckRefund(legacy, "night_vision_lvl", 18);
        totalRefund += CompatibilityManager.CheckRefund(legacy, "fire_resistance_lvl", 18);
        totalRefund += CompatibilityManager.CheckRefund(legacy, "friendly_piglins", 12);
        totalRefund += CompatibilityManager.CheckRefund(legacy, "comestible_rotten_flesh_lvl", 12);
        if ((totalRefund += CompatibilityManager.CheckRefund(legacy, "harvester_lvl", 14)) > 0) {
            SpManager.AddSP(player, totalRefund);
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7e[Tyzs Skills] \u00a7rObsolete skills converted to points: \u00a76+" + totalRefund + " SP")));
            player.level().playSound(null, player.blockPosition(), SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 0.5f, 1.0f);
        }
        player.getPersistentData().putBoolean(MIGRATION_TAG, true);
        XpManager.LevelUpCheck(player);
    }

    private static void MigrateSkill(ServerPlayer player, LegacyData data, String oldKey, String newId) {
        double value = data.getOldValue(oldKey);
        if (value > 0.0) {
            SkillManager.Get().SetSkillLevel(player, newId, (int)value);
        }
    }

    private static int CheckRefund(LegacyData data, String oldKey, int amount) {
        double value = data.getOldValue(oldKey);
        if (value > 0.0) {
            return amount;
        }
        return 0;
    }

    private static void RemoveOldModifier(ServerPlayer player, Holder<Attribute> attribute, String suffix) {
        AttributeInstance instance = player.getAttribute(attribute);
        if (instance == null) {
            return;
        }
        ResourceLocation id = ResourceLocation.parse((String)("tyzs_skills:" + (suffix = suffix.toLowerCase(Locale.ROOT))));
        if (instance.hasModifier(id)) {
            instance.removeModifier(id);
        }
    }
}

