/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.active;

import com.tyzsskills.server.active.AutoSyncClient;
import com.tyzsskills.server.active.ErrorManager;
import com.tyzsskills.server.active.FileManager;
import com.tyzsskills.server.active.LevelManager;
import com.tyzsskills.server.active.PowerManager;
import com.tyzsskills.server.active.SpManager;
import com.tyzsskills.server.attachments.ExplorationProgression;
import com.tyzsskills.server.attachments.StatsTracker;
import com.tyzsskills.server.model.Skill;
import com.tyzsskills.server.skills.SkillManager;
import com.tyzsskills.server.xp.XpManager;
import com.tyzsskills.server.xp.xpEvents.XpBlock;
import com.tyzsskills.server.xp.xpEvents.XpEntity;
import com.tyzsskills.server.xp.xpEvents.XpFood;
import java.io.IOException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class DebugManager {
    public static void DebugReload(MinecraftServer server) throws IOException {
        ErrorManager.ClearErrors();
        SkillManager.Get().ClearSkills();
        XpBlock.ClearValues();
        XpEntity.ClearValues();
        XpFood.ClearValues();
        XpManager.ClearPool();
        FileManager.Get().ReadJsons(server);
        FileManager.Get().ReadLevelPool(server);
        FileManager.Get().ReadXpValues(server);
        FileManager.Get().ReadCustomSkills(server);
        SkillManager manager = SkillManager.Get();
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            AutoSyncClient.SyncSkillList(player);
            AutoSyncClient.SyncConfig(player);
            AutoSyncClient.SyncMainData(player);
            XpManager.LevelUpCheck(player);
            if (!player.hasPermissions(2) || !ErrorManager.HasErrors()) continue;
            ErrorManager.PrintErrors(player);
        }
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            for (Skill skill : manager.GetAllSkills()) {
                if (manager.GetPlayerSkillLevel(player, skill.GetID().toLowerCase()) <= skill.GetMaximumLevel()) continue;
                manager.SetSkillLevel(player, skill.GetID().toLowerCase(), skill.GetMaximumLevel());
            }
        }
    }

    public static void DebugResetData(ServerPlayer player) {
        LevelManager.SetLevel(player, 1);
        SpManager.SetSP(player, 0);
        PowerManager.SetPower(player, 0);
        XpManager.SetXP(player, 0.0f);
        ((ExplorationProgression)player.getData(ExplorationProgression.DATA)).resetPlayerData();
        ((StatsTracker)player.getData(StatsTracker.DATA)).resetStats();
        SkillManager manager = SkillManager.Get();
        for (Skill skill : manager.GetAllSkills()) {
            if (manager.GetPlayerSkillLevel(player, skill.GetID().toLowerCase()) <= 0) continue;
            manager.SetSkillLevel(player, skill.GetID().toLowerCase(), 0);
        }
    }
}

