/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.active;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;

public class ErrorManager {
    private static final List<MutableComponent> ERROR_PRINTS = new ArrayList<MutableComponent>();

    public static void RegisterLoadError(String context, String detail) {
        if (context == null || detail == null) {
            return;
        }
        MutableComponent message = Component.literal((String)"[TyzSkills] ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)("Error when " + context)).withStyle(ChatFormatting.RED)).append((Component)Component.literal((String)(": " + detail)).withStyle(ChatFormatting.WHITE));
        ERROR_PRINTS.add(message);
    }

    public static void RegisterSkillError(String source, String error) {
        if (source == null || error == null) {
            return;
        }
        MutableComponent message = Component.literal((String)"[TyzSkills] ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)"Error in ").withStyle(ChatFormatting.RED)).append((Component)Component.literal((String)("[" + source + "]")).withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)(": " + error)).withStyle(ChatFormatting.WHITE));
        ERROR_PRINTS.add(message);
    }

    public static void ClearErrors() {
        ERROR_PRINTS.clear();
    }

    public static boolean HasErrors() {
        return !ERROR_PRINTS.isEmpty();
    }

    public static void PrintErrors(ServerPlayer player) {
        if (ERROR_PRINTS.isEmpty()) {
            return;
        }
        player.sendSystemMessage((Component)Component.literal((String)("\u00a7c\u26a0 Tyz's Skills loaded with " + ERROR_PRINTS.size() + " error(s):")));
        for (MutableComponent error : ERROR_PRINTS) {
            player.sendSystemMessage((Component)error);
        }
    }
}

