/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.active;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tyzsskills.server.model.BlockXpValuesPreset;
import com.tyzsskills.server.model.EntityXpValuesPreset;
import com.tyzsskills.server.model.FoodValuesPreset;
import com.tyzsskills.server.model.LevelPoolPreset;
import com.tyzsskills.server.model.Skill;
import com.tyzsskills.server.model.SkillsPreset;
import com.tyzsskills.server.skills.SkillLoader;
import com.tyzsskills.server.xp.XpManager;
import com.tyzsskills.server.xp.xpEvents.XpBlock;
import com.tyzsskills.server.xp.xpEvents.XpEntity;
import com.tyzsskills.server.xp.xpEvents.XpFood;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.server.MinecraftServer;

public class FileManager {
    private static final FileManager instance = new FileManager();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static FileManager Get() {
        return instance;
    }

    public void InitPath(MinecraftServer server) {
        Path globalPath = server.getServerDirectory().resolve("config").resolve("tyzs_skills");
        ArrayList<Path> allPaths = new ArrayList<Path>();
        allPaths.add(globalPath.resolve("skills").resolve("default").resolve("abilities"));
        allPaths.add(globalPath.resolve("skills").resolve("default").resolve("fight"));
        allPaths.add(globalPath.resolve("skills").resolve("default").resolve("misc"));
        allPaths.add(globalPath.resolve("skills").resolve("custom"));
        allPaths.add(globalPath.resolve("skills").resolve("traits"));
        for (Path path : allPaths) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void LoadDefaultJson(MinecraftServer server) throws IOException {
        for (Skill skill : SkillsPreset.GetDefaultSkills()) {
            this.WriteSkill(skill, this.GetSkillPath(skill.GetCategory(), server));
        }
    }

    public void LoadDefaultXpValues(MinecraftServer server) throws IOException {
        Path blockFile = server.getServerDirectory().resolve("config").resolve("tyzs_skills").resolve("block-xp-values.json");
        Path entityFile = server.getServerDirectory().resolve("config").resolve("tyzs_skills").resolve("entity-xp-values.json");
        Path foodFile = server.getServerDirectory().resolve("config").resolve("tyzs_skills").resolve("food-xp-values.json");
        if (!Files.exists(blockFile, new LinkOption[0])) {
            Files.writeString(blockFile, (CharSequence)BlockXpValuesPreset.GetDefaultXpValues(), new OpenOption[0]);
        }
        if (!Files.exists(entityFile, new LinkOption[0])) {
            Files.writeString(entityFile, (CharSequence)EntityXpValuesPreset.GetDefaultXpValues(), new OpenOption[0]);
        }
        if (!Files.exists(foodFile, new LinkOption[0])) {
            Files.writeString(foodFile, (CharSequence)FoodValuesPreset.GetDefaultXpValues(), new OpenOption[0]);
        }
    }

    public void LoadDefaulltLevelPool(MinecraftServer server) throws IOException {
        Path poolFile = server.getServerDirectory().resolve("config").resolve("tyzs_skills").resolve("level-pool.json");
        if (!Files.exists(poolFile, new LinkOption[0])) {
            Files.writeString(poolFile, (CharSequence)LevelPoolPreset.GetDefaultRewardValues(), new OpenOption[0]);
        }
    }

    public void ReadJsons(MinecraftServer server) throws IOException {
        Path globalPath = server.getServerDirectory().resolve("config").resolve("tyzs_skills").resolve("skills");
        if (!Files.exists(globalPath, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> stream = Files.walk(globalPath, new FileVisitOption[0]);){
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".json")).forEach(path -> {
                try {
                    String jsonString = Files.readString(path);
                    JsonObject jsonObj = (JsonObject)this.gson.fromJson(jsonString, JsonObject.class);
                    SkillLoader.LoadSKill(jsonObj);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            });
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void ReadXpValues(MinecraftServer server) throws IOException {
        JsonObject obj;
        String content;
        Path blockFile = server.getServerDirectory().resolve("config").resolve("tyzs_skills").resolve("block-xp-values.json");
        Path entityFile = server.getServerDirectory().resolve("config").resolve("tyzs_skills").resolve("entity-xp-values.json");
        Path foodFile = server.getServerDirectory().resolve("config").resolve("tyzs_skills").resolve("food-xp-values.json");
        if (Files.exists(blockFile, new LinkOption[0])) {
            content = Files.readString(blockFile);
            obj = JsonParser.parseString((String)content).getAsJsonObject();
            XpBlock.LoadValues(obj);
        }
        if (Files.exists(entityFile, new LinkOption[0])) {
            content = Files.readString(entityFile);
            obj = JsonParser.parseString((String)content).getAsJsonObject();
            XpEntity.LoadValues(obj);
        }
        if (Files.exists(foodFile, new LinkOption[0])) {
            content = Files.readString(foodFile);
            obj = JsonParser.parseString((String)content).getAsJsonObject();
            XpFood.LoadValues(obj);
        }
    }

    public void ReadLevelPool(MinecraftServer server) throws IOException {
        Path poolFile = server.getServerDirectory().resolve("config").resolve("tyzs_skills").resolve("level-pool.json");
        if (Files.exists(poolFile, new LinkOption[0])) {
            String content = Files.readString(poolFile);
            JsonObject obj = JsonParser.parseString((String)content).getAsJsonObject();
            XpManager.LoadPool(obj);
        }
    }

    public void ReadCustomSkills(MinecraftServer server) {
        Path skillPath = server.getServerDirectory().resolve("config").resolve("tyzs_skills").resolve("skills").resolve("custom");
        if (!Files.exists(skillPath, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> stream = Files.walk(skillPath, new FileVisitOption[0]);){
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".json")).forEach(path -> {
                try {
                    String jsonString = Files.readString(path);
                    JsonObject jsonObj = (JsonObject)this.gson.fromJson(jsonString, JsonObject.class);
                    SkillLoader.LoadSKill(jsonObj);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            });
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void WriteSkill(Skill skill, Path path) throws IOException {
        Path skillFile = path.resolve(skill.GetID() + ".json");
        if (Files.exists(skillFile, new LinkOption[0])) {
            return;
        }
        String skillJson = this.gson.toJson((Object)skill);
        Files.writeString(skillFile, (CharSequence)skillJson, new OpenOption[0]);
    }

    private Path GetSkillPath(Skill.CategoryType category, MinecraftServer server) {
        Path skillPath = server.getServerDirectory().resolve("config").resolve("tyzs_skills").resolve("skills");
        switch (category) {
            case ABILITIES: {
                return skillPath.resolve("default").resolve("abilities");
            }
            case FIGHT: {
                return skillPath.resolve("default").resolve("fight");
            }
            case MISC: 
            case ALL: 
            case BOOKMARKS: {
                return skillPath.resolve("default").resolve("misc");
            }
            case TRAITS: {
                return skillPath.resolve("traits");
            }
        }
        return skillPath;
    }
}

