/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.active;

import com.tyzsskills.server.payloads.LevelDataUpdatePayload;
import com.tyzsskills.server.payloads.LevelUpdatePayload;
import com.tyzsskills.server.xp.XpManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;

public class LevelManager {
    private static final String dataKey = "SKILL_LEVEL";

    public static void SetLevel(ServerPlayer player, int level) {
        if (level <= 0) {
            return;
        }
        CompoundTag playerData = player.getPersistentData();
        playerData.putInt(dataKey, level);
        LevelManager.UpdateClient(player);
    }

    public static void AddLevel(ServerPlayer player, int level) {
        if (level <= 0) {
            return;
        }
        LevelManager.SetLevel(player, LevelManager.GetLevel(player) + level);
    }

    public static void RemoveLevel(ServerPlayer player, int level) {
        if (level <= 0) {
            return;
        }
        int result = Math.max(1, LevelManager.GetLevel(player) - level);
        LevelManager.SetLevel(player, result);
    }

    public static void RestorePlayerLevelData(ServerPlayer oldPlayer, ServerPlayer newPlayer) {
        CompoundTag oldData = oldPlayer.getPersistentData();
        CompoundTag newData = newPlayer.getPersistentData();
        if (oldData.contains(dataKey)) {
            newData.putInt(dataKey, oldData.getInt(dataKey));
            LevelManager.UpdateClient(newPlayer);
        } else {
            LevelManager.SetLevel(newPlayer, 1);
        }
    }

    private static void UpdateClient(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new LevelUpdatePayload(LevelManager.GetLevel(player)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new LevelDataUpdatePayload(XpManager.GetLevelData(LevelManager.GetLevel(player))), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static int GetLevel(ServerPlayer player) {
        return Math.max(1, player.getPersistentData().getInt(dataKey));
    }
}

