/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.active;

import com.tyzsskills.server.payloads.PowerUpdatePayload;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;

public class PowerManager {
    private static final String dataKey = "TRAIT_POWER";

    public static void SetPower(ServerPlayer player, int amount) {
        if (amount < 0) {
            return;
        }
        CompoundTag playerData = player.getPersistentData();
        playerData.putInt(dataKey, amount);
        PowerManager.UpdateClient(player);
    }

    public static void AddPower(ServerPlayer player, int amount) {
        if (amount <= 0) {
            return;
        }
        PowerManager.SetPower(player, PowerManager.GetPower(player) + amount);
    }

    public static void RemovePower(ServerPlayer player, int amount) {
        if (amount <= 0) {
            return;
        }
        int result = Math.max(0, PowerManager.GetPower(player) - amount);
        PowerManager.SetPower(player, result);
    }

    public static void RestorePlayerPowerData(ServerPlayer oldPlayer, ServerPlayer newPlayer) {
        CompoundTag oldData = oldPlayer.getPersistentData();
        CompoundTag newData = newPlayer.getPersistentData();
        if (oldData.contains(dataKey)) {
            newData.putInt(dataKey, oldData.getInt(dataKey));
            PowerManager.UpdateClient(newPlayer);
        } else {
            PowerManager.SetPower(newPlayer, 0);
        }
    }

    private static void UpdateClient(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PowerUpdatePayload(PowerManager.GetPower(player)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static int GetPower(ServerPlayer player) {
        return player.getPersistentData().getInt(dataKey);
    }
}

