/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.active;

import com.tyzsskills.server.payloads.SpUpdatePayload;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;

public class SpManager {
    private static final String dataKey = "SKILL_POINT";

    public static void SetSP(ServerPlayer player, int amount) {
        if (amount < 0) {
            return;
        }
        CompoundTag playerData = player.getPersistentData();
        playerData.putInt(dataKey, amount);
        SpManager.UpdateClient(player);
    }

    public static void AddSP(ServerPlayer player, int amount) {
        if (amount <= 0) {
            return;
        }
        SpManager.SetSP(player, SpManager.GetSP(player) + amount);
    }

    public static void RemoveSP(ServerPlayer player, int amount) {
        if (amount <= 0) {
            return;
        }
        int result = Math.max(0, SpManager.GetSP(player) - amount);
        SpManager.SetSP(player, result);
    }

    public static void RestorePlayerSPData(ServerPlayer oldPlayer, ServerPlayer newPlayer) {
        CompoundTag oldData = oldPlayer.getPersistentData();
        CompoundTag newData = newPlayer.getPersistentData();
        if (oldData.contains(dataKey)) {
            newData.putInt(dataKey, oldData.getInt(dataKey));
            SpManager.UpdateClient(newPlayer);
        } else {
            SpManager.SetSP(newPlayer, 0);
        }
    }

    private static void UpdateClient(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SpUpdatePayload(SpManager.GetSP(player)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static int GetSP(ServerPlayer player) {
        return player.getPersistentData().getInt(dataKey);
    }
}

