/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.attachments;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class BlockMarker
implements INBTSerializable<ListTag> {
    private final Set<Long> placedBLocks = new HashSet<Long>();
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"tyzs_skills");
    public static final Supplier<AttachmentType<BlockMarker>> PLACED_BLOCKS = ATTACHMENT_TYPES.register("placed_blocks", () -> AttachmentType.serializable(BlockMarker::new).build());

    public void addBlock(BlockPos pos) {
        this.placedBLocks.add(pos.asLong());
    }

    public void removeBlock(BlockPos pos) {
        this.placedBLocks.remove(pos.asLong());
    }

    public boolean isPlacedByPlayer(BlockPos pos) {
        return this.placedBLocks.contains(pos.asLong());
    }

    public ListTag serializeNBT(HolderLookup.Provider provider) {
        ListTag list = new ListTag();
        for (Long pos : this.placedBLocks) {
            list.add((Object)LongTag.valueOf((long)pos));
        }
        return list;
    }

    public void deserializeNBT(HolderLookup.Provider provider, ListTag tags) {
        this.placedBLocks.clear();
        for (Tag tag : tags) {
            if (!(tag instanceof LongTag)) continue;
            LongTag longTag = (LongTag)tag;
            this.placedBLocks.add(longTag.getAsLong());
        }
    }

    public static void MarkBlock(Level level, BlockPos pos) {
        if (level.isClientSide) {
            return;
        }
        LevelChunk chunk = level.getChunkAt(pos);
        ((BlockMarker)chunk.getData(PLACED_BLOCKS)).addBlock(pos);
    }

    public static void RemoveBlock(Level level, BlockPos pos) {
        if (level.isClientSide) {
            return;
        }
        LevelChunk chunk = level.getChunkAt(pos);
        ((BlockMarker)chunk.getData(PLACED_BLOCKS)).removeBlock(pos);
    }

    public static boolean IsPlayerPlaced(Level level, BlockPos pos) {
        if (level.isClientSide) {
            return false;
        }
        LevelChunk chunk = level.getChunkAt(pos);
        return ((BlockMarker)chunk.getData(PLACED_BLOCKS)).isPlacedByPlayer(pos);
    }
}

