/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.attachments;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class ExplorationProgression
implements INBTSerializable<CompoundTag> {
    private final Set<String> visitedBiomes = new HashSet<String>();
    private final Set<String> visitedDimensions = new HashSet<String>();
    private long lastSleepDay = -1L;
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"tyzs_skills");
    public static final Supplier<AttachmentType<ExplorationProgression>> DATA = ATTACHMENT_TYPES.register("exploration_xp_data", () -> AttachmentType.serializable(ExplorationProgression::new).copyOnDeath().build());

    public void addBiome(String biomeID) {
        this.visitedBiomes.add(biomeID.toLowerCase());
    }

    public boolean hasDiscoveredBiome(String biomeID) {
        return this.visitedBiomes.contains(biomeID.toLowerCase());
    }

    public void addDimension(String dimensionID) {
        if (!this.hasDiscoveredDimension(dimensionID)) {
            this.visitedDimensions.add(dimensionID.toLowerCase());
        }
    }

    public boolean hasDiscoveredDimension(String dimensionID) {
        return this.visitedDimensions.contains(dimensionID.toLowerCase());
    }

    public boolean hasDiscoveredAnyDimension() {
        return !this.visitedDimensions.isEmpty();
    }

    public boolean hasAlreadySlept(long currentDay) {
        return currentDay <= this.lastSleepDay;
    }

    public void setSleepDay(long currentDay) {
        if (currentDay >= 0L) {
            this.lastSleepDay = currentDay;
        }
    }

    public void resetPlayerData() {
        this.visitedBiomes.clear();
        this.visitedDimensions.clear();
        this.lastSleepDay = -1L;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        ListTag biomeList = new ListTag();
        this.visitedBiomes.forEach(b -> biomeList.add((Object)StringTag.valueOf((String)b)));
        tag.put("biomes", (Tag)biomeList);
        ListTag dimensionList = new ListTag();
        this.visitedDimensions.forEach(b -> dimensionList.add((Object)StringTag.valueOf((String)b)));
        tag.put("dimensions", (Tag)dimensionList);
        tag.putLong("last_sleep_day", this.lastSleepDay);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag compoundTag) {
        this.visitedBiomes.clear();
        this.visitedDimensions.clear();
        if (compoundTag.contains("biomes")) {
            for (Tag biome : compoundTag.getList("biomes", 8)) {
                this.visitedBiomes.add(biome.getAsString());
            }
        }
        if (compoundTag.contains("dimensions")) {
            for (Tag dimension : compoundTag.getList("dimensions", 8)) {
                this.visitedDimensions.add(dimension.getAsString());
            }
        }
        if (compoundTag.contains("last_sleep_day")) {
            this.lastSleepDay = compoundTag.getLong("last_sleep_day");
        }
    }
}

