/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.attachments;

import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class StatsTracker
implements INBTSerializable<CompoundTag> {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"tyzs_skills");
    public static final Supplier<AttachmentType<StatsTracker>> DATA = ATTACHMENT_TYPES.register("player_stats", () -> AttachmentType.serializable(StatsTracker::new).copyOnDeath().build());
    private float allTimeXp = 0.0f;
    private int totalSpEarned = 0;
    private int totalSpSpent = 0;

    public void addXp(float amount) {
        if (amount > 0.0f) {
            this.allTimeXp += amount;
        }
    }

    public void addSpEarned(int amount) {
        if (amount > 0) {
            this.totalSpEarned += amount;
        }
    }

    public void addSpSpent(int amount) {
        if (amount > 0) {
            this.totalSpSpent += amount;
        }
    }

    public void resetStats() {
        this.allTimeXp = 0.0f;
        this.totalSpEarned = 0;
        this.totalSpSpent = 0;
    }

    public void copyFrom(StatsTracker old) {
        this.allTimeXp = old.allTimeXp;
        this.totalSpEarned = old.totalSpEarned;
        this.totalSpSpent = old.totalSpSpent;
    }

    public float getAllTimeXp() {
        return this.allTimeXp;
    }

    public int getTotalSpEarned() {
        return this.totalSpEarned;
    }

    public int getTotalSpSpent() {
        return this.totalSpSpent;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putFloat("allTimeXp", this.allTimeXp);
        tag.putInt("totalSpEarned", this.totalSpEarned);
        tag.putInt("totalSpSpent", this.totalSpSpent);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag compoundTag) {
        if (compoundTag.contains("allTimeXp")) {
            this.allTimeXp = compoundTag.getFloat("allTimeXp");
        }
        if (compoundTag.contains("totalSpEarned")) {
            this.totalSpEarned = compoundTag.getInt("totalSpEarned");
        }
        if (compoundTag.contains("totalSpSpent")) {
            this.totalSpSpent = compoundTag.getInt("totalSpSpent");
        }
    }
}

