/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.tyzsskills.server.active.DebugManager;
import com.tyzsskills.server.active.LevelManager;
import com.tyzsskills.server.active.SpManager;
import com.tyzsskills.server.model.Skill;
import com.tyzsskills.server.skills.SkillManager;
import com.tyzsskills.server.xp.XpManager;
import java.io.IOException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;

public class MainCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"skills").requires(src -> src.hasPermission(3))).then(MainCommand.xp())).then(MainCommand.level())).then(MainCommand.sp())).then(MainCommand.skill())).then(MainCommand.reload())).then(MainCommand.reset());
    }

    private static LiteralArgumentBuilder<CommandSourceStack> xp() {
        return (LiteralArgumentBuilder)Commands.literal((String)"xp").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.literal((String)"add").then(Commands.argument((String)"amount", (ArgumentType)FloatArgumentType.floatArg((float)0.1f)).executes(ctx -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
            float amount = FloatArgumentType.getFloat((CommandContext)ctx, (String)"amount");
            XpManager.AddXP(player, amount);
            return 1;
        })))).then(Commands.literal((String)"remove").then(Commands.argument((String)"amount", (ArgumentType)FloatArgumentType.floatArg((float)0.1f)).executes(ctx -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
            float amount = FloatArgumentType.getFloat((CommandContext)ctx, (String)"amount");
            XpManager.RemoveXP(player, amount);
            return 1;
        })))).then(Commands.literal((String)"set").then(Commands.argument((String)"amount", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(ctx -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
            float amount = FloatArgumentType.getFloat((CommandContext)ctx, (String)"amount");
            XpManager.SetXP(player, amount);
            return 1;
        }))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> level() {
        return (LiteralArgumentBuilder)Commands.literal((String)"level").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.literal((String)"add").then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            LevelManager.AddLevel(player, amount);
            return 1;
        })))).then(Commands.literal((String)"remove").then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            LevelManager.RemoveLevel(player, amount);
            return 1;
        })))).then(Commands.literal((String)"set").then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            LevelManager.SetLevel(player, amount);
            return 1;
        }))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> sp() {
        return (LiteralArgumentBuilder)Commands.literal((String)"point").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.literal((String)"add").then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            SpManager.AddSP(player, amount);
            return 1;
        })))).then(Commands.literal((String)"remove").then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            SpManager.RemoveSP(player, amount);
            return 1;
        })))).then(Commands.literal((String)"set").then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            SpManager.SetSP(player, amount);
            return 1;
        }))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> skill() {
        return (LiteralArgumentBuilder)Commands.literal((String)"skill").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.literal((String)"set").then(Commands.argument((String)"skill_id", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(SkillManager.Get().GetAllSkills().stream().map(Skill::GetID), (SuggestionsBuilder)builder)).then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)10)).executes(ctx -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
            String id = StringArgumentType.getString((CommandContext)ctx, (String)"skill_id");
            int level = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"level");
            SkillManager.Get().SetSkillLevel(player, id, level);
            return 1;
        }))))).then(Commands.literal((String)"add").then(Commands.argument((String)"skill_id", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(SkillManager.Get().GetAllSkills().stream().map(Skill::GetID), (SuggestionsBuilder)builder)).then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10)).executes(ctx -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
            String id = StringArgumentType.getString((CommandContext)ctx, (String)"skill_id");
            int level = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"level");
            SkillManager.Get().AddSKillLevel(player, id, level);
            return 1;
        }))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"skill_id", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(SkillManager.Get().GetAllSkills().stream().map(Skill::GetID), (SuggestionsBuilder)builder)).then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10)).executes(ctx -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
            String id = StringArgumentType.getString((CommandContext)ctx, (String)"skill_id");
            int level = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"level");
            SkillManager.Get().RemoveSkillLevel(player, id, level);
            return 1;
        })))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> reload() {
        return (LiteralArgumentBuilder)Commands.literal((String)"reload").executes(ctx -> {
            try {
                DebugManager.DebugReload(((CommandSourceStack)ctx.getSource()).getServer());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return 1;
        });
    }

    private static LiteralArgumentBuilder<CommandSourceStack> reset() {
        return (LiteralArgumentBuilder)Commands.literal((String)"reset").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ctx -> {
            DebugManager.DebugResetData(EntityArgument.getPlayer((CommandContext)ctx, (String)"player"));
            return 1;
        }));
    }
}

