/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.effects;

import com.tyzsskills.server.model.Skill;
import com.tyzsskills.server.skills.SkillManager;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class GenericEffects {
    public static void ApplyEffect(Skill skill, ServerPlayer player) {
        ResourceLocation attributeID = ResourceLocation.tryParse((String)skill.GetModifier());
        if (attributeID == null) {
            return;
        }
        Attribute attribute = (Attribute)BuiltInRegistries.ATTRIBUTE.get(attributeID);
        if (attribute == null) {
            return;
        }
        Optional attributeHolderOpt = BuiltInRegistries.ATTRIBUTE.getHolder(attributeID);
        if (attributeHolderOpt.isEmpty()) {
            return;
        }
        AttributeInstance instance = player.getAttribute((Holder)attributeHolderOpt.get());
        if (instance == null) {
            return;
        }
        ResourceLocation modifierID = ResourceLocation.fromNamespaceAndPath((String)"tyzs_skills", (String)("skill_modifier_" + skill.GetID()));
        int currentLvl = player.getPersistentData().getInt(skill.GetID() + "_lvl");
        if (currentLvl <= 0) {
            return;
        }
        int index = Math.min(currentLvl - 1, skill.GetValues().size() - 1);
        float value = skill.GetValues().get(index).floatValue();
        if (skill.GetModifierOperation() == AttributeModifier.Operation.ADD_MULTIPLIED_BASE || skill.GetModifierOperation() == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL) {
            value /= 100.0f;
        }
        AttributeModifier.Operation operation = skill.GetModifierOperation();
        if (skill.GetModifier().equals("minecraft:generic.oxygen_bonus")) {
            operation = AttributeModifier.Operation.ADD_VALUE;
            value += 0.75f;
        }
        AttributeModifier modifier = new AttributeModifier(modifierID, (double)value, operation);
        if (instance.hasModifier(modifierID)) {
            instance.removeModifier(modifierID);
        }
        instance.addPermanentModifier(modifier);
    }

    public static void RemoveEffect(Skill skill, ServerPlayer player) {
        ResourceLocation attributeID = ResourceLocation.parse((String)skill.GetModifier());
        Attribute attribute = (Attribute)BuiltInRegistries.ATTRIBUTE.get(attributeID);
        if (attribute == null) {
            return;
        }
        Optional attributeHolderOpt = BuiltInRegistries.ATTRIBUTE.getHolder(attributeID);
        if (attributeHolderOpt.isEmpty()) {
            return;
        }
        AttributeInstance instance = player.getAttribute((Holder)attributeHolderOpt.get());
        if (instance == null) {
            return;
        }
        ResourceLocation modifierID = ResourceLocation.fromNamespaceAndPath((String)"tyzs_skills", (String)("skill_modifier_" + skill.GetID()));
        instance.removeModifier(modifierID);
    }

    public static void RestaureEffects(ServerPlayer newPlayer) {
        for (Skill skill : SkillManager.Get().GetAllSkills()) {
            if (skill.GetType() != Skill.SkillType.GENERIC) continue;
            String key = skill.GetID() + "_lvl";
            int value = newPlayer.getPersistentData().getInt(key);
            if (value <= 0) continue;
            GenericEffects.ApplyEffect(skill, newPlayer);
        }
    }
}

