/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.effects.skillEffects;

import com.tyzsskills.server.model.Skill;
import com.tyzsskills.server.model.SkillBehaviour;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

public class CriticalHitEffect
extends SkillBehaviour {
    @Override
    public void onPlayerAttack(LivingIncomingDamageEvent event, ServerPlayer player, int lvl, Skill skill) {
        List<Float> values = skill.GetValues();
        if (values == null || values.isEmpty()) {
            return;
        }
        int index = Math.min(lvl - 1, values.size() - 1);
        float chancePercentage = values.get(index).floatValue();
        if (player.getRandom().nextFloat() < chancePercentage / 100.0f) {
            event.setAmount(event.getAmount() * 2.0f);
            this.NotifyClient(player, skill);
            Level level = player.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.CRIT, event.getEntity().getX(), event.getEntity().getY() + 1.5, event.getEntity().getZ(), 15, 0.5, 0.5, 0.5, 0.1);
            }
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_CRIT, player.getSoundSource(), 1.0f, 1.0f);
        }
    }
}

