/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.effects.skillEffects;

import com.tyzsskills.server.model.Skill;
import com.tyzsskills.server.model.SkillBehaviour;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

public class DamageDealEffect
extends SkillBehaviour {
    public static final ThreadLocal<Boolean> IS_REFLECTING = ThreadLocal.withInitial(() -> false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onIncomingDamage(LivingIncomingDamageEvent event, ServerPlayer player, int lvl, Skill skill) {
        Entity entity;
        if (IS_REFLECTING.get().booleanValue()) {
            return;
        }
        List<Float> values = skill.GetValues();
        if (values == null || values.isEmpty()) {
            return;
        }
        int index = Math.min(lvl - 1, values.size() - 1);
        float chancePercentage = values.get(index).floatValue();
        if (player.getRandom().nextFloat() < chancePercentage / 100.0f && (entity = event.getSource().getEntity()) instanceof LivingEntity) {
            LivingEntity source = (LivingEntity)entity;
            event.setCanceled(true);
            IS_REFLECTING.set(true);
            try {
                DamageSource damageSrc = player.damageSources().playerAttack((Player)player);
                source.hurt(damageSrc, event.getAmount());
                this.NotifyClient(player, skill);
            }
            finally {
                IS_REFLECTING.set(false);
            }
        }
    }
}

