/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.effects.skillEffects;

import com.tyzsskills.Config;
import com.tyzsskills.server.attachments.BlockMarker;
import com.tyzsskills.server.effects.skillEffects.RefinerEffect;
import com.tyzsskills.server.model.Skill;
import com.tyzsskills.server.model.SkillBehaviour;
import com.tyzsskills.server.skills.SkillManager;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.level.BlockEvent;

public class DeepLodeEffect
extends SkillBehaviour {
    private static final ThreadLocal<Boolean> IS_MINING = ThreadLocal.withInitial(() -> false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPlayerBreakBlock(BlockEvent.BreakEvent event, ServerPlayer player, int lvl, Skill skill) {
        if (IS_MINING.get().booleanValue()) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        if (player.isShiftKeyDown()) {
            return;
        }
        BlockState state = event.getState();
        if (!state.is(Tags.Blocks.ORES)) {
            return;
        }
        ItemStack tool = player.getMainHandItem();
        if (!tool.isCorrectToolForDrops(state)) {
            return;
        }
        BlockPos startPos = event.getPos();
        Block targetBlock = state.getBlock();
        event.setCanceled(true);
        IS_MINING.set(true);
        int MAX_BLOCKS = Config.MAX_ORES.getAsInt();
        boolean griefProtection = Config.DEEP_LODE_GRIEF_PROTECTION.getAsBoolean();
        try {
            boolean hasSilkTouch;
            LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            queue.add(startPos);
            visited.add(startPos);
            int blocksBroken = 0;
            int playerPlacedCount = 0;
            Vec3 dropPos = Vec3.atCenterOf((Vec3i)startPos).add(0.0, 0.5, 0.0);
            if (!tool.isCorrectToolForDrops(state)) {
                return;
            }
            Holder.Reference silkTouchHolder = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.SILK_TOUCH);
            ItemEnchantments enchants = (ItemEnchantments)tool.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
            boolean bl = hasSilkTouch = enchants.getLevel((Holder)silkTouchHolder) > 0;
            while (!queue.isEmpty() && blocksBroken < MAX_BLOCKS) {
                boolean success;
                List<ItemStack> smelted;
                BlockPos currentPos = (BlockPos)queue.poll();
                BlockState currentState = level.getBlockState(currentPos);
                if (!currentState.is(targetBlock)) continue;
                if (BlockMarker.IsPlayerPlaced((Level)level, currentPos) && ++playerPlacedCount > 2 && griefProtection) {
                    return;
                }
                if (!currentPos.equals((Object)startPos)) {
                    BlockEvent.BreakEvent checkEvent = new BlockEvent.BreakEvent((Level)level, currentPos, currentState, (Player)player);
                    NeoForge.EVENT_BUS.post((Event)checkEvent);
                    if (checkEvent.isCanceled()) continue;
                }
                LootParams.Builder lootParams = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)currentPos)).withParameter(LootContextParams.TOOL, (Object)tool).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withParameter(LootContextParams.BLOCK_STATE, (Object)currentState);
                List<ItemStack> drops = currentState.getDrops(lootParams);
                if (SkillManager.Get().GetPlayerSkillLevel(player, "refiner") > 0 && !hasSilkTouch && (smelted = RefinerEffect.smeltDrops((Level)level, drops)) != null) {
                    drops = smelted;
                    this.NotifyClient(player, SkillManager.Get().GetSkill("refiner"));
                }
                int vanillaXp = currentState.getExpDrop((LevelAccessor)level, currentPos, level.getBlockEntity(currentPos), (Entity)player, tool);
                if (hasSilkTouch) {
                    vanillaXp = 0;
                }
                if (currentPos.equals((Object)startPos)) {
                    success = level.destroyBlock(currentPos, false, (Entity)player);
                } else {
                    success = level.removeBlock(currentPos, false);
                    if (success) {
                        player.awardStat(Stats.BLOCK_MINED.get((Object)currentState.getBlock()));
                        if (vanillaXp > 0) {
                            ExperienceOrb orb = new ExperienceOrb((Level)level, dropPos.x, dropPos.y, dropPos.z, vanillaXp);
                            level.addFreshEntity((Entity)orb);
                        }
                    }
                }
                if (!success) continue;
                for (ItemStack item : drops) {
                    if (item.isEmpty()) continue;
                    ItemEntity entity = new ItemEntity((Level)level, dropPos.x, dropPos.y, dropPos.z, item.copy());
                    entity.setDefaultPickUpDelay();
                    entity.setDeltaMovement(Vec3.ZERO);
                    level.addFreshEntity((Entity)entity);
                }
                player.causeFoodExhaustion(0.005f);
                ++blocksBroken;
                tool.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                if (tool.isEmpty()) break;
                this.addNeighbors(currentPos, queue, visited);
            }
            if (blocksBroken > 0) {
                this.NotifyClient(player, skill);
            }
        }
        finally {
            IS_MINING.set(false);
        }
    }

    private void addNeighbors(BlockPos pos, Queue<BlockPos> queue, Set<BlockPos> visited) {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    BlockPos neighbor;
                    if (dx == 0 && dy == 0 && dz == 0 || visited.contains(neighbor = pos.offset(dx, dy, dz))) continue;
                    visited.add(neighbor);
                    queue.add(neighbor);
                }
            }
        }
    }
}

