/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.effects.skillEffects;

import com.tyzsskills.server.attachments.BlockMarker;
import com.tyzsskills.server.model.Skill;
import com.tyzsskills.server.model.SkillBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DeadBushBlock;
import net.minecraft.world.level.block.KelpBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.PumpkinBlock;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.event.level.BlockEvent;

public class GreenThumbEffect
extends SkillBehaviour {
    @Override
    public void onPlayerBreakBlock(BlockEvent.BreakEvent event, ServerPlayer player, int lvl, Skill skill) {
        CropBlock crop;
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)levelAccessor;
        if (BlockMarker.IsPlayerPlaced((Level)serverLevel, event.getPos())) {
            return;
        }
        BlockState state = event.getState();
        Block block = state.getBlock();
        boolean flag = false;
        if (block instanceof CropBlock && (crop = (CropBlock)block).isMaxAge(state)) {
            flag = true;
        } else if (block instanceof NetherWartBlock && (Integer)state.getValue((Property)NetherWartBlock.AGE) >= 3) {
            flag = true;
        } else if (block instanceof CocoaBlock && (Integer)state.getValue((Property)CocoaBlock.AGE) >= 2) {
            flag = true;
        } else if (block instanceof TallGrassBlock || block instanceof DeadBushBlock) {
            flag = true;
        } else if (block instanceof TallSeagrassBlock || block instanceof SeagrassBlock || block instanceof KelpBlock) {
            flag = true;
        } else if (block instanceof PumpkinBlock) {
            flag = true;
        } else if (block instanceof CactusBlock || block instanceof SugarCaneBlock || block instanceof BambooStalkBlock) {
            flag = true;
        } else if (state.is(BlockTags.LEAVES)) {
            flag = true;
        } else if (state.is(Blocks.MELON)) {
            flag = true;
        } else if (state.is(Blocks.FERN) || state.is(Blocks.LARGE_FERN)) {
            flag = true;
        } else if (state.is(Blocks.SHORT_GRASS)) {
            flag = true;
        }
        if (!flag) {
            return;
        }
        List<Float> values = skill.GetValues();
        if (values == null || values.isEmpty()) {
            return;
        }
        int index = Math.min(lvl - 1, values.size() - 1);
        float chancePercentage = values.get(index).floatValue();
        if (player.getRandom().nextFloat() < chancePercentage / 100.0f) {
            BlockPos position = event.getPos();
            Block.dropResources((BlockState)state, (Level)serverLevel, (BlockPos)position, (BlockEntity)serverLevel.getBlockEntity(position), (Entity)player, (ItemStack)player.getMainHandItem());
            this.NotifyClient(player, skill);
        }
    }
}

