/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.effects.skillEffects;

import com.tyzsskills.server.model.Skill;
import com.tyzsskills.server.model.SkillBehaviour;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MagnetEffect
extends SkillBehaviour {
    @Override
    public void onPlayerTick(ServerPlayer player, int lvl, Skill skill) {
        if (player.isDeadOrDying() || player.isSpectator() || player.isCrouching()) {
            return;
        }
        List<Float> values = skill.GetValues();
        if (values == null || values.isEmpty()) {
            return;
        }
        int index = Math.min(lvl - 1, values.size() - 1);
        float blockRadiusValue = values.get(index).floatValue();
        int blockRadius = (int)blockRadiusValue;
        AABB searchBox = player.getBoundingBox().inflate((double)blockRadius);
        List items = player.level().getEntitiesOfClass(ItemEntity.class, searchBox);
        for (ItemEntity item : items) {
            Vec3 itemPos;
            Vec3 targetPos;
            Vec3 direction;
            if (item.hasPickUpDelay() || !item.isAlive() || !((direction = (targetPos = player.position().add(0.0, 0.5, 0.0)).subtract(itemPos = item.position())).lengthSqr() > 0.01)) continue;
            Vec3 motion = direction.normalize().scale(0.2);
            item.setDeltaMovement(item.getDeltaMovement().scale(0.5).add(motion));
        }
    }
}

