/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.effects.skillEffects;

import com.tyzsskills.server.model.Skill;
import com.tyzsskills.server.model.SkillBehaviour;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;

public class NutritionEffect
extends SkillBehaviour {
    @Override
    public void onPlayerFinishUsingItem(LivingEntityUseItemEvent.Finish event, ServerPlayer player, int lvl, Skill skill) {
        ItemStack item = event.getItem();
        FoodProperties foodValue = item.getFoodProperties((LivingEntity)player);
        if (foodValue == null) {
            return;
        }
        List<Float> values = skill.GetValues();
        if (values == null || values.isEmpty()) {
            return;
        }
        int index = Math.min(lvl - 1, values.size() - 1);
        float bonusPercentage = values.get(index).floatValue() / 100.0f;
        int nutritionBonus = Math.round((float)foodValue.nutrition() * bonusPercentage);
        if (nutritionBonus > 0) {
            player.getFoodData().eat(nutritionBonus, foodValue.saturation() * 0.5f);
            this.NotifyClient(player, skill);
        }
    }
}

