/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.effects.skillEffects;

import com.tyzsskills.server.model.Skill;
import com.tyzsskills.server.model.SkillBehaviour;
import com.tyzsskills.server.skills.SkillManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.level.BlockEvent;

public class RefinerEffect
extends SkillBehaviour {
    private static final ThreadLocal<Boolean> IS_SMELTING = ThreadLocal.withInitial(() -> false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPlayerBreakBlock(BlockEvent.BreakEvent event, ServerPlayer player, int lvl, Skill skill) {
        if (IS_SMELTING.get().booleanValue()) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        if (player.isShiftKeyDown()) {
            return;
        }
        if (SkillManager.Get().GetPlayerSkillLevel(player, "deep_lode") > 0) {
            return;
        }
        BlockState state = event.getState();
        if (!state.is(Tags.Blocks.ORES)) {
            return;
        }
        ItemStack tool = player.getMainHandItem();
        if (!tool.isCorrectToolForDrops(state)) {
            return;
        }
        Holder.Reference silkTouchHolder = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.SILK_TOUCH);
        ItemEnchantments enchants = (ItemEnchantments)tool.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        if (enchants.getLevel((Holder)silkTouchHolder) > 0) {
            return;
        }
        IS_SMELTING.set(true);
        try {
            BlockEvent.BreakEvent checkEvent = new BlockEvent.BreakEvent((Level)level, event.getPos(), state, (Player)player);
            NeoForge.EVENT_BUS.post((Event)checkEvent);
            if (checkEvent.isCanceled()) {
                return;
            }
            LootParams.Builder lootParams = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)event.getPos())).withParameter(LootContextParams.TOOL, (Object)tool).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withParameter(LootContextParams.BLOCK_STATE, (Object)state);
            List originalDrops = state.getDrops(lootParams);
            List<ItemStack> smeltedDrops = RefinerEffect.smeltDrops((Level)level, originalDrops);
            if (smeltedDrops == null) {
                return;
            }
            event.setCanceled(true);
            boolean success = level.destroyBlock(event.getPos(), false, (Entity)player);
            if (success) {
                for (ItemStack item : smeltedDrops) {
                    BlockPos pos = event.getPos();
                    ItemEntity entity = new ItemEntity((Level)level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, item.copy());
                    entity.setDefaultPickUpDelay();
                    level.addFreshEntity((Entity)entity);
                }
                this.NotifyClient(player, skill);
            }
        }
        finally {
            IS_SMELTING.set(false);
        }
    }

    public static List<ItemStack> smeltDrops(Level level, List<ItemStack> originalDrops) {
        ArrayList<ItemStack> newDrops = new ArrayList<ItemStack>();
        boolean atLeastOneSmelted = false;
        for (ItemStack stack : originalDrops) {
            Optional recipe = level.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(stack), level);
            if (recipe.isPresent()) {
                ItemStack result = ((SmeltingRecipe)((RecipeHolder)recipe.get()).value()).getResultItem((HolderLookup.Provider)level.registryAccess()).copy();
                result.setCount(stack.getCount() * result.getCount());
                newDrops.add(result);
                atLeastOneSmelted = true;
                continue;
            }
            newDrops.add(stack);
        }
        return atLeastOneSmelted ? newDrops : null;
    }
}

