/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.effects.skillEffects;

import com.tyzsskills.server.model.Skill;
import com.tyzsskills.server.model.SkillBehaviour;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;

public class ResilienceEffect
extends SkillBehaviour {
    public static final ThreadLocal<Boolean> IS_MODIFYING = ThreadLocal.withInitial(() -> false);

    @Override
    public void onStartingEffect(MobEffectEvent.Added event, ServerPlayer player, int lvl, Skill skill) {
        if (IS_MODIFYING.get().booleanValue()) {
            return;
        }
        MobEffectInstance effect = event.getEffectInstance();
        if (effect.isAmbient()) {
            return;
        }
        if (((MobEffect)effect.getEffect().value()).getCategory() != MobEffectCategory.HARMFUL) {
            return;
        }
        int originalDuration = effect.getDuration();
        if (originalDuration >= 1728000) {
            return;
        }
        List<Float> values = skill.GetValues();
        if (values == null || values.isEmpty()) {
            return;
        }
        int index = Math.min(lvl - 1, values.size() - 1);
        float reductionPercentage = values.get(index).floatValue();
        if (reductionPercentage <= 0.0f) {
            return;
        }
        int newDuration = (int)((float)originalDuration * (1.0f - reductionPercentage / 100.0f));
        if (newDuration < 20) {
            return;
        }
        int capturedDuration = newDuration;
        player.getServer().execute(() -> {
            if (player.isRemoved()) {
                return;
            }
            IS_MODIFYING.set(true);
            try {
                player.removeEffect(effect.getEffect());
                MobEffectInstance newEffect = new MobEffectInstance(effect.getEffect(), capturedDuration, effect.getAmplifier(), effect.isAmbient(), effect.isVisible(), effect.showIcon());
                player.addEffect(newEffect);
                this.NotifyClient(player, skill);
            }
            finally {
                IS_MODIFYING.set(false);
            }
        });
    }
}

