/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.effects.skillEffects;

import com.tyzsskills.server.model.Skill;
import com.tyzsskills.server.model.SkillBehaviour;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

public class ResistanceEffect
extends SkillBehaviour {
    @Override
    public void onIncomingDamage(LivingIncomingDamageEvent event, ServerPlayer player, int lvl, Skill skill) {
        List<Float> values = skill.GetValues();
        if (values == null || values.isEmpty()) {
            return;
        }
        DamageSource damageSource = event.getSource();
        if (damageSource.is(DamageTypeTags.BYPASSES_RESISTANCE)) {
            return;
        }
        int index = Math.min(lvl - 1, values.size() - 1);
        float value = values.get(index).floatValue();
        if (value >= 100.0f) {
            event.setCanceled(true);
            return;
        }
        float damageAbsorption = 1.0f - values.get(index).floatValue() / 100.0f;
        float newDmg = event.getAmount() * damageAbsorption;
        event.setAmount(newDmg);
    }
}

