/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.events;

import com.tyzsskills.Config;
import com.tyzsskills.server.active.AutoSyncClient;
import com.tyzsskills.server.active.CompatibilityManager;
import com.tyzsskills.server.active.ErrorManager;
import com.tyzsskills.server.active.LevelManager;
import com.tyzsskills.server.active.SpManager;
import com.tyzsskills.server.attachments.BlockMarker;
import com.tyzsskills.server.effects.GenericEffects;
import com.tyzsskills.server.events.SkillEffectsEvents;
import com.tyzsskills.server.skills.SkillManager;
import com.tyzsskills.server.xp.XpManager;
import com.tyzsskills.server.xp.xpEvents.XpBlock;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class RuntimeEvents {
    @SubscribeEvent
    public static void OnPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        CompatibilityManager.ProcessMigration(player2);
        AutoSyncClient.SyncMainData(player2);
        AutoSyncClient.SyncSkillList(player2);
        AutoSyncClient.SyncSkillLevels(player2);
        AutoSyncClient.SyncConfig(player2);
        AutoSyncClient.SyncSkillBookmarks(player2);
        AutoSyncClient.SyncStats(player2);
        if (player2.hasPermissions(2) && ErrorManager.HasErrors()) {
            ErrorManager.PrintErrors(player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        ServerPlayer oldPlayer;
        Player player;
        block5: {
            block4: {
                player = event.getOriginal();
                if (!(player instanceof ServerPlayer)) break block4;
                oldPlayer = (ServerPlayer)player;
                player = event.getEntity();
                if (player instanceof ServerPlayer) break block5;
            }
            return;
        }
        ServerPlayer newPlayer = (ServerPlayer)player;
        if (event.isWasDeath()) {
            XpManager.RestorePlayerXPData(oldPlayer, newPlayer);
            LevelManager.RestorePlayerLevelData(oldPlayer, newPlayer);
            SpManager.RestorePlayerSPData(oldPlayer, newPlayer);
            SkillManager.Get().RestaureSkillData(oldPlayer, newPlayer);
            GenericEffects.RestaureEffects(newPlayer);
        }
        SkillEffectsEvents.OnPlayerClone(event);
    }

    @SubscribeEvent
    public static void OnBlockPlace(BlockEvent.EntityPlaceEvent event) {
        if (event.isCanceled() || !((Boolean)Config.PREVENT_PLACED_BLOCK_XP.get()).booleanValue()) {
            return;
        }
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        if (event.getState().getBlock() instanceof CropBlock || event.getState().getBlock() instanceof NetherWartBlock) {
            return;
        }
        if (XpBlock.GetBlockValue(event.getState()) > 0.0f) {
            BlockMarker.MarkBlock((Level)event.getLevel(), event.getPos());
        }
    }
}

