/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.events;

import com.tyzsskills.server.model.Skill;
import com.tyzsskills.server.skills.SkillManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.PlayLevelSoundEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerWakeUpEvent;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class SkillEffectsEvents {
    private static final String[] playerTickSkills = new String[]{"magnet", "silver_tongue", "deep_sight"};
    private static final String[] entityVisibility = new String[]{"stealth"};

    @SubscribeEvent
    public static void OnPlayerAttack(LivingIncomingDamageEvent event) {
        if (event.isCanceled()) {
            return;
        }
        SkillManager manager = SkillManager.Get();
        Entity entity = event.getSource().getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            for (Skill skill : manager.GetAllSkills()) {
                int lvl;
                if (!skill.HasBehaviour() || (lvl = manager.GetPlayerSkillLevel(player, skill.GetID())) <= 0) continue;
                skill.GetBehaviour().onPlayerAttack(event, player, lvl, skill);
            }
        }
    }

    @SubscribeEvent
    public static void OnIncomingDamage(LivingIncomingDamageEvent event) {
        if (event.isCanceled()) {
            return;
        }
        SkillManager manager = SkillManager.Get();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            for (Skill skill : manager.GetAllSkills()) {
                int lvl;
                if (!skill.HasBehaviour() || (lvl = manager.GetPlayerSkillLevel(player, skill.GetID())) <= 0) continue;
                skill.GetBehaviour().onIncomingDamage(event, player, lvl, skill);
            }
        }
    }

    @SubscribeEvent
    public static void OnPlayerKill(LivingDeathEvent event) {
        if (event.isCanceled()) {
            return;
        }
        SkillManager manager = SkillManager.Get();
        Entity entity = event.getSource().getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            for (Skill skill : manager.GetAllSkills()) {
                int lvl;
                if (!skill.HasBehaviour() || (lvl = manager.GetPlayerSkillLevel(player, skill.GetID())) <= 0) continue;
                skill.GetBehaviour().onPlayerKill(event, player, lvl, skill);
            }
        }
    }

    @SubscribeEvent
    public static void OnStartingEffect(MobEffectEvent.Added event) {
        SkillManager manager = SkillManager.Get();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            for (Skill skill : manager.GetAllSkills()) {
                int lvl;
                if (!skill.HasBehaviour() || (lvl = manager.GetPlayerSkillLevel(player, skill.GetID())) <= 0) continue;
                skill.GetBehaviour().onStartingEffect(event, player, lvl, skill);
            }
        }
    }

    @SubscribeEvent
    public static void OnPlayerBreakBlock(BlockEvent.BreakEvent event) {
        if (event.isCanceled()) {
            return;
        }
        SkillManager manager = SkillManager.Get();
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            for (Skill skill : manager.GetAllSkills()) {
                int lvl;
                if (!skill.HasBehaviour() || (lvl = manager.GetPlayerSkillLevel(player2, skill.GetID())) <= 0) continue;
                skill.GetBehaviour().onPlayerBreakBlock(event, player2, lvl, skill);
            }
        }
    }

    @SubscribeEvent
    public static void OnPlayerFinishUsingItem(LivingEntityUseItemEvent.Finish event) {
        SkillManager manager = SkillManager.Get();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            for (Skill skill : manager.GetAllSkills()) {
                int lvl;
                if (!skill.HasBehaviour() || (lvl = manager.GetPlayerSkillLevel(player, skill.GetID())) <= 0) continue;
                skill.GetBehaviour().onPlayerFinishUsingItem(event, player, lvl, skill);
            }
        }
    }

    @SubscribeEvent
    public static void OnPickupXp(PlayerXpEvent.PickupXp event) {
        if (event.isCanceled()) {
            return;
        }
        SkillManager manager = SkillManager.Get();
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            for (Skill skill : manager.GetAllSkills()) {
                int lvl;
                if (!skill.HasBehaviour() || (lvl = manager.GetPlayerSkillLevel(player2, skill.GetID())) <= 0) continue;
                skill.GetBehaviour().onPickupXp(event, player2, lvl, skill);
            }
        }
    }

    @SubscribeEvent
    public static void OnEffectApplicable(MobEffectEvent.Applicable event) {
        SkillManager manager = SkillManager.Get();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            for (Skill skill : manager.GetAllSkills()) {
                int lvl;
                if (!skill.HasBehaviour() || (lvl = manager.GetPlayerSkillLevel(player, skill.GetID())) <= 0) continue;
                skill.GetBehaviour().onEffectApplicable(event, player, lvl, skill);
            }
        }
    }

    @SubscribeEvent
    public static void OnTargetChange(LivingChangeTargetEvent event) {
        if (event.isCanceled()) {
            return;
        }
        SkillManager manager = SkillManager.Get();
        LivingEntity livingEntity = event.getNewAboutToBeSetTarget();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            for (Skill skill : manager.GetAllSkills()) {
                int lvl;
                if (!skill.HasBehaviour() || (lvl = manager.GetPlayerSkillLevel(player, skill.GetID())) <= 0) continue;
                skill.GetBehaviour().onTargetChange(event, player, lvl, skill);
            }
        }
    }

    @SubscribeEvent
    public static void OnPlayerDeath(LivingDeathEvent event) {
        if (event.isCanceled()) {
            return;
        }
        SkillManager manager = SkillManager.Get();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            for (Skill skill : manager.GetAllSkills()) {
                int lvl;
                if (!skill.HasBehaviour() || (lvl = manager.GetPlayerSkillLevel(player, skill.GetID())) <= 0) continue;
                skill.GetBehaviour().onPlayerDeath(event, player, lvl, skill);
            }
        }
    }

    public static void OnPlayerClone(PlayerEvent.Clone event) {
        SkillManager manager = SkillManager.Get();
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            for (Skill skill : manager.GetAllSkills()) {
                int lvl;
                if (!skill.HasBehaviour() || (lvl = manager.GetPlayerSkillLevel(player2, skill.GetID())) <= 0) continue;
                skill.GetBehaviour().onPlayerClone(event, player2, lvl, skill);
            }
        }
    }

    @SubscribeEvent
    public static void OnNoiseAtPlayer(PlayLevelSoundEvent.AtEntity event) {
        if (event.isCanceled()) {
            return;
        }
        SkillManager manager = SkillManager.Get();
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            for (Skill skill : manager.GetAllSkills()) {
                int lvl;
                if (!skill.HasBehaviour() || (lvl = manager.GetPlayerSkillLevel(player, skill.GetID())) <= 0) continue;
                skill.GetBehaviour().OnNoiseAtPlayer(event, player, lvl, skill);
            }
        }
    }

    @SubscribeEvent
    public static void OnPlayerWakeUp(PlayerWakeUpEvent event) {
        SkillManager manager = SkillManager.Get();
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            for (Skill skill : manager.GetAllSkills()) {
                int lvl;
                if (!skill.HasBehaviour() || (lvl = manager.GetPlayerSkillLevel(player2, skill.GetID())) <= 0) continue;
                skill.GetBehaviour().OnPlayerWakeUp(event, player2, lvl, skill);
            }
        }
    }

    @SubscribeEvent
    public static void OnPlayerTick(PlayerTickEvent.Post event) {
        SkillManager manager = SkillManager.Get();
        String[] stringArray = event.getEntity();
        if (stringArray instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)stringArray;
            for (String id : playerTickSkills) {
                int lvl;
                Skill skill = SkillManager.Get().GetSkill(id.toLowerCase());
                if (skill == null || !skill.HasBehaviour() || (lvl = manager.GetPlayerSkillLevel(player, skill.GetID())) <= 0) continue;
                skill.GetBehaviour().onPlayerTick(player, lvl, skill);
            }
        }
    }

    @SubscribeEvent
    public static void OnLivingVisibility(LivingEvent.LivingVisibilityEvent event) {
        SkillManager manager = SkillManager.Get();
        String[] stringArray = event.getEntity();
        if (stringArray instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)stringArray;
            for (String id : entityVisibility) {
                int lvl;
                Skill skill = SkillManager.Get().GetSkill(id.toLowerCase());
                if (skill == null || !skill.HasBehaviour() || (lvl = manager.GetPlayerSkillLevel(player, skill.GetID())) <= 0) continue;
                skill.GetBehaviour().onLivingVisibility(event, player, lvl, skill);
            }
        }
    }
}

