/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.events;

import com.tyzsskills.Config;
import com.tyzsskills.server.active.AttributeRegistry;
import com.tyzsskills.server.attachments.BlockMarker;
import com.tyzsskills.server.attachments.ExplorationProgression;
import com.tyzsskills.server.xp.XpManager;
import com.tyzsskills.server.xp.xpEvents.XpBlock;
import com.tyzsskills.server.xp.xpEvents.XpEntity;
import com.tyzsskills.server.xp.xpEvents.XpFood;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.AdvancementEvent;
import net.neoforged.neoforge.event.entity.player.ItemFishedEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerWakeUpEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class XpGainsEvents {
    @SubscribeEvent
    public static void OnBlockBreak(BlockEvent.BreakEvent event) {
        BlockPos pos;
        Level level;
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (player2.isCreative() && !((Boolean)Config.EARN_XP_IN_CREATIVE.get()).booleanValue()) {
            return;
        }
        if (((Boolean)Config.PREVENT_PLACED_BLOCK_XP.get()).booleanValue() && BlockMarker.IsPlayerPlaced(level = (Level)event.getLevel(), pos = event.getPos())) {
            BlockMarker.RemoveBlock(level, pos);
            return;
        }
        XpBlock.BlockBreakProfit(event.getState(), player2);
    }

    @SubscribeEvent
    public static void OnEntityDeath(LivingDeathEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (player.isCreative() && !((Boolean)Config.EARN_XP_IN_CREATIVE.get()).booleanValue()) {
            return;
        }
        XpEntity.EntityKillProfit((Entity)event.getEntity(), player);
    }

    @SubscribeEvent
    public static void OnEntityWakeup(PlayerWakeUpEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Level level = player2.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (player2.isCreative() && !((Boolean)Config.EARN_XP_IN_CREATIVE.get()).booleanValue()) {
            return;
        }
        long timeOfDay = level2.getDayTime() % 24000L;
        if (timeOfDay > 1000L) {
            return;
        }
        double sleepValue = (Double)Config.SLEEPING_XP_VALUE.get();
        if (sleepValue <= 0.0) {
            return;
        }
        long currentDay = player2.level().getDayTime() / 24000L;
        ExplorationProgression data = (ExplorationProgression)player2.getData(ExplorationProgression.DATA);
        if (!data.hasAlreadySlept(currentDay)) {
            data.setSleepDay(currentDay);
            XpManager.AddXP(player2, (float)(sleepValue *= player2.getAttributeValue(AttributeRegistry.SKILL_XP_MULTIPLIER)));
        }
    }

    @SubscribeEvent
    public static void OnEntityFish(ItemFishedEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (player2.isCreative() && !((Boolean)Config.EARN_XP_IN_CREATIVE.get()).booleanValue()) {
            return;
        }
        float value = (float)Config.FISHING_XP_VALUE.getAsDouble();
        if (value <= 0.0f) {
            return;
        }
        XpManager.AddXP(player2, value *= (float)player2.getAttributeValue(AttributeRegistry.SKILL_XP_MULTIPLIER));
    }

    @SubscribeEvent
    public static void OnEntityEat(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        if (player.isCreative() && !((Boolean)Config.EARN_XP_IN_CREATIVE.get()).booleanValue()) {
            return;
        }
        if (!((Boolean)Config.EARN_XP_BY_EATING.get()).booleanValue()) {
            return;
        }
        if (event.getItem().getFoodProperties((LivingEntity)player) == null) {
            return;
        }
        XpFood.FoodEatProfit(event.getItem(), player);
    }

    @SubscribeEvent
    public static void OnItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (player2.isCreative() && !((Boolean)Config.EARN_XP_IN_CREATIVE.get()).booleanValue()) {
            return;
        }
        float value = (float)Config.CRAFTING_XP_VALUE.getAsDouble();
        if (value <= 0.0f) {
            return;
        }
        XpManager.AddXP(player2, value *= (float)player2.getAttributeValue(AttributeRegistry.SKILL_XP_MULTIPLIER));
    }

    @SubscribeEvent
    public static void OnBabySpawn(BabyEntitySpawnEvent event) {
        Player player = event.getCausedByPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (player2.isCreative() && !((Boolean)Config.EARN_XP_IN_CREATIVE.get()).booleanValue()) {
            return;
        }
        float value = (float)Config.BREEDING_XP_VALUE.getAsDouble();
        if (value <= 0.0f) {
            return;
        }
        XpManager.AddXP(player2, value *= (float)player2.getAttributeValue(AttributeRegistry.SKILL_XP_MULTIPLIER));
    }

    @SubscribeEvent
    public static void OnAdvancement(AdvancementEvent.AdvancementEarnEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (player2.isCreative() && !((Boolean)Config.EARN_XP_IN_CREATIVE.get()).booleanValue()) {
            return;
        }
        if (event.getAdvancement().id().toString().startsWith("minecraft:recipes/")) {
            return;
        }
        float taskValue = (float)Config.ADVANCEMENT_TASK_XP_VALUE.getAsDouble();
        float goalValue = (float)Config.ADVANCEMENT_GOAL_XP_VALUE.getAsDouble();
        float challengeValue = (float)Config.ADVANCEMENT_CHALLENGE_XP_VALUE.getAsDouble();
        event.getAdvancement().value().display().ifPresent(info -> {
            float finalValue;
            switch (info.getType()) {
                default: {
                    throw new MatchException(null, null);
                }
                case TASK: {
                    float f = taskValue;
                    break;
                }
                case GOAL: {
                    float f = goalValue;
                    break;
                }
                case CHALLENGE: {
                    float f = finalValue = challengeValue;
                }
            }
            if (finalValue <= 0.0f) {
                return;
            }
            XpManager.AddXP(player2, finalValue *= (float)player2.getAttributeValue(AttributeRegistry.SKILL_XP_MULTIPLIER));
        });
    }

    @SubscribeEvent
    public static void OnPlayerTick(PlayerTickEvent.Post event) {
        String biomeID;
        ResourceKey biomeKey;
        if (event.getEntity().tickCount % 100 != 0) {
            return;
        }
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (player2.isCreative() && !((Boolean)Config.EARN_XP_IN_CREATIVE.get()).booleanValue()) {
            return;
        }
        ExplorationProgression data = (ExplorationProgression)player2.getData(ExplorationProgression.DATA);
        double biomeValue = (Double)Config.NEW_BIOME_XP_VALUE.get();
        double dimensionValue = (Double)Config.NEW_DIMENSION_XP_VALUE.get();
        if (biomeValue > 0.0 && (biomeKey = player2.level().getBiome(player2.blockPosition()).getKey()) != null && !data.hasDiscoveredBiome(biomeID = biomeKey.location().toString())) {
            data.addBiome(biomeID);
            XpManager.AddXP(player2, (float)(biomeValue *= player2.getAttributeValue(AttributeRegistry.SKILL_XP_MULTIPLIER)));
        }
        if (dimensionValue > 0.0) {
            String dimensionID = player2.level().dimension().location().toString();
            if (!data.hasDiscoveredAnyDimension()) {
                data.addDimension(dimensionID);
                return;
            }
            if (!data.hasDiscoveredDimension(dimensionID)) {
                data.addDimension(dimensionID);
                XpManager.AddXP(player2, (float)(dimensionValue *= player2.getAttributeValue(AttributeRegistry.SKILL_XP_MULTIPLIER)));
            }
        }
    }
}

