/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.model;

import com.tyzsskills.server.model.SkillBehaviour;
import com.tyzsskills.server.model.Trait;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.jetbrains.annotations.NotNull;

public class Skill {
    protected transient SkillBehaviour behaviour;
    protected boolean active;
    protected String id;
    protected int maximumLevel;
    protected List<Integer> prices;
    protected List<Float> values;
    protected SkillType type;
    protected CategoryType category;
    protected String modifier;
    protected AttributeModifier.Operation operation;
    protected boolean purchasable;
    protected String icon;
    protected String displayName;
    protected String description;
    protected String unit;
    public static final StreamCodec<FriendlyByteBuf, Skill> STREAM_CODEC = StreamCodec.ofMember((skill, buffer) -> {
        boolean isTrait = skill instanceof Trait;
        buffer.writeBoolean(isTrait);
        skill.WriteToBuffer((FriendlyByteBuf)buffer);
    }, buffer -> {
        boolean isTrait = buffer.readBoolean();
        if (isTrait) {
            return Trait.ReadTraitFromBuffer(buffer);
        }
        return Skill.ReadTraitFromBuffer(buffer);
    });

    public Skill(boolean active, String id, int maximumLevel, List<Integer> prices, List<Float> values, SkillType type, CategoryType category, String modifier, AttributeModifier.Operation operation, boolean purchasable, String icon, String displayName, String description, String unit) {
        this.active = active;
        this.id = id;
        this.maximumLevel = maximumLevel;
        this.prices = new ArrayList<Integer>(prices);
        this.values = new ArrayList<Float>(values);
        this.type = type;
        this.category = category;
        this.modifier = modifier;
        this.operation = operation;
        this.purchasable = purchasable;
        this.icon = icon;
        this.displayName = displayName;
        this.description = description;
        this.unit = unit;
        if (category == CategoryType.ALL || category == CategoryType.BOOKMARKS) {
            category = CategoryType.MISC;
        }
    }

    public boolean IsSkillActive() {
        return this.active;
    }

    public String GetID() {
        return this.id;
    }

    public int GetMaximumLevel() {
        return this.maximumLevel;
    }

    public List<Integer> GetPrices() {
        return Collections.unmodifiableList(this.prices);
    }

    public String GetModifier() {
        return this.modifier;
    }

    public List<Float> GetValues() {
        return Collections.unmodifiableList(this.values);
    }

    public SkillType GetType() {
        return this.type;
    }

    public CategoryType GetCategory() {
        return this.category;
    }

    public AttributeModifier.Operation GetModifierOperation() {
        return this.operation;
    }

    public boolean IsPurchasable() {
        return this.purchasable;
    }

    public String GetIcon() {
        return this.icon;
    }

    public String GetDisplayName() {
        return this.displayName;
    }

    public String GetDescription() {
        return this.description;
    }

    public String GetUnit() {
        return this.unit;
    }

    public SkillBehaviour GetBehaviour() {
        return this.behaviour;
    }

    public boolean HasBehaviour() {
        return this.behaviour != null;
    }

    public void SetBehaviour(SkillBehaviour behaviour) {
        if (behaviour != null) {
            this.behaviour = behaviour;
        }
    }

    public void WriteToBuffer(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.active);
        buffer.writeUtf(this.id);
        buffer.writeInt(this.maximumLevel);
        buffer.writeCollection(this.prices, FriendlyByteBuf::writeInt);
        buffer.writeCollection(this.values, FriendlyByteBuf::writeFloat);
        buffer.writeEnum((Enum)this.type);
        buffer.writeEnum((Enum)this.category);
        buffer.writeUtf(this.modifier);
        buffer.writeEnum((Enum)this.operation);
        buffer.writeBoolean(this.purchasable);
        buffer.writeUtf(this.icon);
        buffer.writeUtf(this.displayName);
        buffer.writeUtf(this.description);
        buffer.writeUtf(this.unit);
    }

    @NotNull
    public static Skill ReadTraitFromBuffer(FriendlyByteBuf buffer) {
        boolean active = buffer.readBoolean();
        String id = buffer.readUtf();
        int maxLevel = buffer.readInt();
        List prices = (List)buffer.readCollection(ArrayList::new, FriendlyByteBuf::readInt);
        List values = (List)buffer.readCollection(ArrayList::new, FriendlyByteBuf::readFloat);
        SkillType type = (SkillType)buffer.readEnum(SkillType.class);
        CategoryType category = (CategoryType)buffer.readEnum(CategoryType.class);
        String modifier = buffer.readUtf();
        AttributeModifier.Operation operation = (AttributeModifier.Operation)buffer.readEnum(AttributeModifier.Operation.class);
        boolean purchasable = buffer.readBoolean();
        String icon = buffer.readUtf();
        String displayName = buffer.readUtf();
        String description = buffer.readUtf();
        String unit = buffer.readUtf();
        return new Skill(active, id, maxLevel, prices, values, type, category, modifier, operation, purchasable, icon, displayName, description, unit);
    }

    public static enum SkillType {
        GENERIC,
        CUSTOM,
        IMMUTABLE,
        TRAIT;

    }

    public static enum CategoryType {
        ALL,
        ABILITIES,
        FIGHT,
        MISC,
        BOOKMARKS,
        TRAITS;

    }

    public static enum ContainerType {
        SKILLS,
        QUESTS,
        TRAITS;

    }
}

