/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.model;

import com.tyzsskills.server.model.Skill;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.jetbrains.annotations.NotNull;

public class Trait
extends Skill {
    protected int powerWeight;

    public Trait(boolean active, String id, int powerWeight, int price, boolean purchasable, String icon, String displayName, String description) {
        super(active, id, 1, List.of(Integer.valueOf(price)), List.of(), Skill.SkillType.TRAIT, Skill.CategoryType.TRAITS, "", AttributeModifier.Operation.ADD_VALUE, purchasable, icon, displayName, description, "");
        this.powerWeight = powerWeight;
    }

    public int getPowerWeight() {
        return this.powerWeight;
    }

    @Override
    public void WriteToBuffer(FriendlyByteBuf buffer) {
        super.WriteToBuffer(buffer);
        buffer.writeInt(this.powerWeight);
    }

    @NotNull
    public static Trait ReadTraitFromBuffer(FriendlyByteBuf buffer) {
        boolean active = buffer.readBoolean();
        String id = buffer.readUtf();
        int maxLevel = buffer.readInt();
        List prices = (List)buffer.readCollection(ArrayList::new, FriendlyByteBuf::readInt);
        List values = (List)buffer.readCollection(ArrayList::new, FriendlyByteBuf::readFloat);
        Skill.SkillType type = (Skill.SkillType)buffer.readEnum(Skill.SkillType.class);
        Skill.CategoryType category = (Skill.CategoryType)buffer.readEnum(Skill.CategoryType.class);
        String modifier = buffer.readUtf();
        AttributeModifier.Operation operation = (AttributeModifier.Operation)buffer.readEnum(AttributeModifier.Operation.class);
        boolean purchasable = buffer.readBoolean();
        String icon = buffer.readUtf();
        String displayName = buffer.readUtf();
        String description = buffer.readUtf();
        String unit = buffer.readUtf();
        int powerWeight = buffer.readInt();
        int price = prices.isEmpty() ? 0 : (Integer)prices.getFirst();
        return new Trait(active, id, powerWeight, price, purchasable, icon, displayName, description);
    }
}

