/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.payloads;

import com.tyzsskills.client.ClientCache;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ConfigSyncPayload(boolean refundSys, double refundPer, int traitLevel, boolean traitSys) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ConfigSyncPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tyzs_skills", (String)"config_sync_payload"));
    public static final StreamCodec<ByteBuf, ConfigSyncPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, ConfigSyncPayload::refundSys, (StreamCodec)ByteBufCodecs.DOUBLE, ConfigSyncPayload::refundPer, (StreamCodec)ByteBufCodecs.INT, ConfigSyncPayload::traitLevel, (StreamCodec)ByteBufCodecs.BOOL, ConfigSyncPayload::traitSys, ConfigSyncPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void Handle(ConfigSyncPayload payload, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            HashMap<String, Object> configMap = new HashMap<String, Object>();
            configMap.put("refund_system", payload.refundSys());
            configMap.put("refund_percentage", payload.refundPer());
            configMap.put("trait_unlock", payload.traitLevel());
            configMap.put("trait_system", payload.traitSys());
            ClientCache.SyncConfig(configMap);
        });
    }
}

