/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.payloads;

import com.tyzsskills.client.ClientCache;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record XpUpdatePayload(float xp, float gained) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<XpUpdatePayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tyzs_skills", (String)"xp_update_payload"));
    public static final StreamCodec<ByteBuf, XpUpdatePayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, XpUpdatePayload::xp, (StreamCodec)ByteBufCodecs.FLOAT, XpUpdatePayload::gained, XpUpdatePayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void Handle(XpUpdatePayload payload, IPayloadContext ctx) {
        ctx.enqueueWork(() -> ClientCache.UpdateClientCacheXP(payload.xp(), payload.gained));
    }
}

