/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.skills;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tyzsskills.Config;
import com.tyzsskills.server.active.ErrorManager;
import com.tyzsskills.server.model.Skill;
import com.tyzsskills.server.model.Trait;
import com.tyzsskills.server.skills.SkillManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class SkillLoader {
    public static void LoadSKill(JsonObject source) {
        Integer powerWeight;
        String unit;
        String description;
        String displayName;
        Boolean purchasable;
        Skill.SkillType type;
        String id = SkillLoader.GetSafeString(source, "id");
        if (id == null || id.isBlank()) {
            ErrorManager.RegisterSkillError("Unknow", "invalid id");
            return;
        }
        id = id.toLowerCase();
        Boolean state = SkillLoader.GetSafeBool(source, "active");
        if (state == null) {
            state = false;
        }
        if (!state.booleanValue()) {
            return;
        }
        List<Object> prices = new ArrayList();
        List<Object> values = new ArrayList();
        Integer maxLevel = SkillLoader.GetSafeInt(source, "maximumLevel");
        if (maxLevel == null) {
            maxLevel = 1;
        }
        maxLevel = Math.min(Math.max(maxLevel, 1), 10);
        if (source.has("prices")) {
            List<Integer> tempPrices = SkillLoader.GetSafeIntArray(source, "prices");
            if (tempPrices == null) {
                ErrorManager.RegisterSkillError(id, "invalid price list");
                return;
            }
            prices = tempPrices;
        }
        if (source.has("values")) {
            List<Float> tempValues = SkillLoader.GetSafeFloatArray(source, "values");
            if (tempValues == null) {
                ErrorManager.RegisterSkillError(id, "invalid value list");
                return;
            }
            values = tempValues;
        }
        if ((type = SkillLoader.GetSafeType(source, "type")) == null) {
            ErrorManager.RegisterSkillError(id, "invalid skill type");
            return;
        }
        Skill.CategoryType category = SkillLoader.GetSafeCategory(source, "category");
        if (category == null) {
            category = Skill.CategoryType.MISC;
        }
        if ((purchasable = SkillLoader.GetSafeBool(source, "purchasable")) == null) {
            purchasable = true;
        }
        AttributeModifier.Operation operation = SkillLoader.GetSafeOperation(source, "operation");
        String modifier = SkillLoader.GetSafeString(source, "modifier");
        String icon = SkillLoader.GetSafeString(source, "icon");
        if (icon == null) {
            icon = "tyzs_skills:textures/gui/skills/default.png";
        }
        if ((displayName = SkillLoader.GetSafeString(source, "displayName")) == null) {
            displayName = "Unknown skill";
        }
        if ((description = SkillLoader.GetSafeString(source, "description")) == null) {
            description = "Missing description";
        }
        if ((unit = SkillLoader.GetSafeString(source, "unit")) == null) {
            unit = "";
        }
        if ((powerWeight = SkillLoader.GetSafeInt(source, "powerWeight")) == null) {
            powerWeight = 0;
        }
        powerWeight = Math.max(0, powerWeight);
        if (type == Skill.SkillType.TRAIT || powerWeight > 0) {
            if (!((Boolean)Config.TRAIT_SYSTEM.get()).booleanValue()) {
                return;
            }
            int price = prices.isEmpty() ? 0 : (Integer)prices.getFirst();
            SkillManager.Get().RegisterSKill(new Trait(state, id, powerWeight, price, purchasable, icon, displayName, description));
            return;
        }
        if (prices.size() < maxLevel) {
            ErrorManager.RegisterSkillError(id, "Not enough prices defined. Expected " + maxLevel + ", got " + prices.size());
            return;
        }
        if (!values.isEmpty() && prices.size() != values.size()) {
            ErrorManager.RegisterSkillError(id, "Array Size Mismatch: 'prices' and 'values' must have the same length.");
            return;
        }
        if (operation == null) {
            if (type == Skill.SkillType.GENERIC || type == Skill.SkillType.CUSTOM) {
                ErrorManager.RegisterSkillError(id, "Missing 'operation' for GENERIC/CUSTOM skill.");
                return;
            }
            operation = AttributeModifier.Operation.ADD_VALUE;
        }
        if (modifier == null && (type == Skill.SkillType.GENERIC || type == Skill.SkillType.CUSTOM)) {
            ErrorManager.RegisterSkillError(id, "Missing modifier");
            return;
        }
        SkillManager.Get().RegisterSKill(new Skill(state, id, maxLevel, prices, values, type, category, modifier, operation, purchasable, icon, displayName, description, unit));
    }

    private static String GetSafeString(JsonObject obj, String key) {
        if (obj == null || key == null) {
            return null;
        }
        JsonElement value = obj.get(key);
        if (value == null || !value.isJsonPrimitive()) {
            return null;
        }
        return value.getAsString();
    }

    private static Integer GetSafeInt(JsonObject obj, String key) {
        if (obj == null || key == null) {
            return null;
        }
        JsonElement value = obj.get(key);
        if (value == null || !value.isJsonPrimitive()) {
            return null;
        }
        return value.getAsInt();
    }

    private static Boolean GetSafeBool(JsonObject obj, String key) {
        if (obj == null || key == null) {
            return null;
        }
        JsonElement value = obj.get(key);
        if (value == null || !value.isJsonPrimitive()) {
            return null;
        }
        return value.getAsBoolean();
    }

    private static List<Integer> GetSafeIntArray(JsonObject obj, String key) {
        if (obj == null || key == null) {
            return null;
        }
        JsonElement arrayValue = obj.get(key);
        if (arrayValue == null || !arrayValue.isJsonArray()) {
            return null;
        }
        JsonArray array = arrayValue.getAsJsonArray();
        ArrayList<Integer> prices = new ArrayList<Integer>();
        for (JsonElement iteration : array) {
            prices.add(iteration.getAsInt());
        }
        return prices;
    }

    private static List<Float> GetSafeFloatArray(JsonObject obj, String key) {
        if (obj == null || key == null) {
            return null;
        }
        JsonElement arrayValue = obj.get(key);
        if (arrayValue == null || !arrayValue.isJsonArray()) {
            return null;
        }
        JsonArray array = arrayValue.getAsJsonArray();
        ArrayList<Float> values = new ArrayList<Float>();
        for (JsonElement iteration : array) {
            values.add(Float.valueOf(iteration.getAsFloat()));
        }
        return values;
    }

    private static Skill.SkillType GetSafeType(JsonObject obj, String key) {
        Skill.SkillType type;
        if (obj == null || key == null) {
            return null;
        }
        JsonElement typeValue = obj.get(key);
        if (typeValue == null || !typeValue.isJsonPrimitive()) {
            return null;
        }
        String typeValueString = typeValue.getAsString();
        if (typeValueString == null) {
            return null;
        }
        try {
            type = Skill.SkillType.valueOf(typeValueString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return type;
    }

    private static Skill.CategoryType GetSafeCategory(JsonObject obj, String key) {
        Skill.CategoryType category;
        if (obj == null || key == null) {
            return null;
        }
        JsonElement typeValue = obj.get(key);
        if (typeValue == null || !typeValue.isJsonPrimitive()) {
            return null;
        }
        String typeValueString = typeValue.getAsString();
        if (typeValueString == null) {
            return null;
        }
        try {
            category = Skill.CategoryType.valueOf(typeValueString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return category;
    }

    private static AttributeModifier.Operation GetSafeOperation(JsonObject obj, String key) {
        AttributeModifier.Operation operation;
        if (obj == null || key == null) {
            return null;
        }
        JsonElement typeValue = obj.get(key);
        if (typeValue == null || !typeValue.isJsonPrimitive()) {
            return null;
        }
        String typeValueString = typeValue.getAsString();
        if (typeValueString == null) {
            return null;
        }
        try {
            operation = AttributeModifier.Operation.valueOf((String)typeValueString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return operation;
    }
}

