/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.skills;

import com.tyzsskills.Config;
import com.tyzsskills.server.active.AttributeRegistry;
import com.tyzsskills.server.active.LevelManager;
import com.tyzsskills.server.active.PowerManager;
import com.tyzsskills.server.active.SpManager;
import com.tyzsskills.server.attachments.StatsTracker;
import com.tyzsskills.server.effects.GenericEffects;
import com.tyzsskills.server.model.Skill;
import com.tyzsskills.server.model.SkillBehaviour;
import com.tyzsskills.server.model.Trait;
import com.tyzsskills.server.payloads.SkillBookmarksPayload;
import com.tyzsskills.server.payloads.SkillLevelSyncPayload;
import com.tyzsskills.server.payloads.StatsSpEarnedPayload;
import com.tyzsskills.server.payloads.StatsSpSpentPayload;
import com.tyzsskills.server.skills.SkillBehaviourRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.neoforged.neoforge.network.PacketDistributor;

public class SkillManager {
    private static final SkillManager instance = new SkillManager();
    public static final String BOOKMARK_SIGNATURE = "_bookmark";
    public static final String SKILL_LEVEL_SIGNATURE = "_lvl";
    private final Map<String, Skill> skillCollection = new HashMap<String, Skill>();

    public static SkillManager Get() {
        return instance;
    }

    public void RegisterSKill(Skill skill) {
        SkillBehaviour behaviour = SkillBehaviourRegistry.GetBehaviour(skill.GetID());
        if (behaviour != null) {
            skill.SetBehaviour(behaviour);
        }
        if (!this.skillCollection.containsKey(skill.GetID())) {
            this.skillCollection.put(skill.GetID(), skill);
        }
    }

    public void ClearSkills() {
        this.skillCollection.clear();
    }

    public void BuySkill(ServerPlayer player, String id) {
        String key;
        CompoundTag data;
        int currentLvl;
        Skill skill = this.GetSkill(id);
        if (player == null || skill == null) {
            return;
        }
        if (skill instanceof Trait) {
            if (!((Boolean)Config.TRAIT_SYSTEM.get()).booleanValue()) {
                return;
            }
            if (LevelManager.GetLevel(player) < (Integer)Config.TRAIT_UNLOCK_LEVEL.get()) {
                return;
            }
        }
        if ((currentLvl = (data = player.getPersistentData()).getInt(key = skill.GetID() + SKILL_LEVEL_SIGNATURE)) >= skill.GetMaximumLevel()) {
            return;
        }
        if (skill instanceof Trait) {
            Trait trait = (Trait)skill;
            AttributeInstance attr = player.getAttribute(AttributeRegistry.TRAIT_POWER);
            if (attr == null) {
                return;
            }
            int freeSpace = (int)attr.getValue() - PowerManager.GetPower(player);
            if (trait.getPowerWeight() > freeSpace) {
                return;
            }
            List<Integer> prices = skill.GetPrices();
            if (currentLvl >= prices.size()) {
                return;
            }
            int price = prices.get(currentLvl);
            if (SpManager.GetSP(player) >= price) {
                SpManager.RemoveSP(player, price);
                data.putInt(key, currentLvl + 1);
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SkillLevelSyncPayload(skill.GetID(), currentLvl + 1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new StatsSpSpentPayload(price), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((StatsTracker)player.getData(StatsTracker.DATA)).addSpSpent(price);
                PowerManager.AddPower(player, trait.getPowerWeight());
            }
        } else {
            List<Integer> prices = skill.GetPrices();
            if (currentLvl >= prices.size()) {
                return;
            }
            int price = prices.get(currentLvl);
            if (SpManager.GetSP(player) >= price) {
                SpManager.RemoveSP(player, price);
                data.putInt(key, currentLvl + 1);
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SkillLevelSyncPayload(skill.GetID(), currentLvl + 1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new StatsSpSpentPayload(price), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((StatsTracker)player.getData(StatsTracker.DATA)).addSpSpent(price);
                if (skill.GetType() == Skill.SkillType.GENERIC) {
                    GenericEffects.ApplyEffect(skill, player);
                }
            }
        }
    }

    public void RefundSkill(ServerPlayer player, String id) {
        List<Integer> prices;
        String key;
        CompoundTag data;
        int currentLvl;
        Skill skill = this.GetSkill(id);
        if (player == null || skill == null || !((Boolean)Config.REFUND_SYSTEM.get()).booleanValue()) {
            return;
        }
        if (skill instanceof Trait) {
            if (!((Boolean)Config.TRAIT_SYSTEM.get()).booleanValue()) {
                return;
            }
            if (LevelManager.GetLevel(player) < (Integer)Config.TRAIT_UNLOCK_LEVEL.get()) {
                return;
            }
        }
        if ((currentLvl = (data = player.getPersistentData()).getInt(key = skill.GetID() + SKILL_LEVEL_SIGNATURE)) <= 0 || currentLvl > skill.GetMaximumLevel()) {
            return;
        }
        if (skill.GetType() == Skill.SkillType.GENERIC) {
            ResourceLocation attributeID = ResourceLocation.tryParse((String)skill.GetModifier());
            if (attributeID == null) {
                return;
            }
            Attribute attribute = (Attribute)BuiltInRegistries.ATTRIBUTE.get(attributeID);
            if (attribute == AttributeRegistry.TRAIT_POWER.get()) {
                float currentValue;
                AttributeInstance att = player.getAttribute(AttributeRegistry.TRAIT_POWER);
                if (att == null) {
                    return;
                }
                int max = (int)att.getValue();
                int current = PowerManager.GetPower(player);
                int index = Math.min(currentLvl - 1, skill.GetValues().size() - 1);
                float powerLoss = currentValue = skill.GetValues().get(index).floatValue();
                if (currentLvl > 1) {
                    int prevIndex = Math.min(currentLvl - 2, skill.GetValues().size() - 1);
                    float prevValue = skill.GetValues().get(prevIndex).floatValue();
                    powerLoss = currentValue - prevValue;
                }
                if (current > max - (int)powerLoss) {
                    return;
                }
            }
        }
        if (currentLvl > (prices = skill.GetPrices()).size()) {
            return;
        }
        int initialPrice = prices.get(currentLvl - 1);
        int finalPrice = Math.max(1, (int)((double)initialPrice * ((Double)Config.REFUND_PERCENTAGE.get() / 100.0)));
        SpManager.AddSP(player, finalPrice);
        int newLvl = currentLvl - 1;
        if (newLvl > 0) {
            data.putInt(key, currentLvl - 1);
        } else {
            data.remove(key);
        }
        if (skill instanceof Trait) {
            Trait trait = (Trait)skill;
            PowerManager.RemovePower(player, trait.getPowerWeight());
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SkillLevelSyncPayload(skill.GetID(), currentLvl - 1), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new StatsSpEarnedPayload(finalPrice), (CustomPacketPayload[])new CustomPacketPayload[0]);
        ((StatsTracker)player.getData(StatsTracker.DATA)).addSpEarned(finalPrice);
        if (skill.GetType() == Skill.SkillType.GENERIC) {
            if (currentLvl - 1 <= 0) {
                GenericEffects.RemoveEffect(skill, player);
            } else {
                GenericEffects.ApplyEffect(skill, player);
            }
        }
    }

    public void RestaureSkillData(ServerPlayer oldPlayer, ServerPlayer newPlayer) {
        if (oldPlayer == null || newPlayer == null) {
            return;
        }
        for (Skill skill : this.skillCollection.values()) {
            String key = skill.GetID() + SKILL_LEVEL_SIGNATURE;
            int oldValue = oldPlayer.getPersistentData().getInt(key);
            if (oldValue > 0) {
                newPlayer.getPersistentData().putInt(key, oldValue);
                PacketDistributor.sendToPlayer((ServerPlayer)newPlayer, (CustomPacketPayload)new SkillLevelSyncPayload(skill.GetID().toLowerCase(), oldValue), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            String key2 = skill.GetID() + BOOKMARK_SIGNATURE;
            boolean oldValue2 = oldPlayer.getPersistentData().getBoolean(key2);
            if (!oldValue2) continue;
            newPlayer.getPersistentData().putBoolean(key2, true);
            PacketDistributor.sendToPlayer((ServerPlayer)newPlayer, (CustomPacketPayload)new SkillBookmarksPayload(skill.GetID().toLowerCase(), true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void BookmarkSkill(ServerPlayer player, String id) {
        boolean newValue;
        String key;
        if (player == null || this.GetSkill(id.toLowerCase()) == null) {
            return;
        }
        CompoundTag data = player.getPersistentData();
        boolean isCurrentlyBookmarked = data.getBoolean(key = id.toLowerCase() + BOOKMARK_SIGNATURE);
        boolean bl = newValue = !isCurrentlyBookmarked;
        if (newValue) {
            data.putBoolean(key, true);
        } else {
            data.remove(key);
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SkillBookmarksPayload(id.toLowerCase(), newValue), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void SetSkillLevel(ServerPlayer player, String id, int lvl) {
        if (player == null || lvl < 0 || lvl > 10) {
            return;
        }
        Skill skill = this.GetSkill(id.toLowerCase());
        if (skill == null) {
            return;
        }
        if (skill instanceof Trait) {
            if (!((Boolean)Config.TRAIT_SYSTEM.get()).booleanValue()) {
                return;
            }
            if (LevelManager.GetLevel(player) < (Integer)Config.TRAIT_UNLOCK_LEVEL.get()) {
                return;
            }
        }
        CompoundTag data = player.getPersistentData();
        String key = id + SKILL_LEVEL_SIGNATURE;
        lvl = Math.max(0, Math.min(lvl, skill.GetMaximumLevel()));
        int oldLvl = this.GetPlayerSkillLevel(player, id);
        if (lvl > 0) {
            data.putInt(key, lvl);
        } else {
            data.remove(key);
        }
        if (skill instanceof Trait) {
            Trait trait = (Trait)skill;
            if (oldLvl == 0 && lvl > 0) {
                PowerManager.AddPower(player, trait.getPowerWeight());
            } else if (oldLvl > 0 && lvl == 0) {
                PowerManager.RemovePower(player, trait.getPowerWeight());
            }
        }
        int diff = lvl - oldLvl;
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SkillLevelSyncPayload(id, lvl), (CustomPacketPayload[])new CustomPacketPayload[0]);
        if (skill.GetType() == Skill.SkillType.GENERIC) {
            if (lvl > 0) {
                GenericEffects.ApplyEffect(skill, player);
            } else {
                GenericEffects.RemoveEffect(skill, player);
            }
        }
    }

    public void AddSKillLevel(ServerPlayer player, String id, int amount) {
        int current = this.GetPlayerSkillLevel(player, id);
        this.SetSkillLevel(player, id, current + amount);
    }

    public void RemoveSkillLevel(ServerPlayer player, String id, int amount) {
        int current = this.GetPlayerSkillLevel(player, id);
        this.SetSkillLevel(player, id, current - amount);
    }

    public Skill GetSkill(String id) {
        return this.skillCollection.getOrDefault(id.toLowerCase(), null);
    }

    public int GetLoadedSkills() {
        return this.skillCollection.size();
    }

    public List<Skill> GetAllSkills() {
        return new ArrayList<Skill>(this.skillCollection.values());
    }

    public int GetPlayerSkillLevel(ServerPlayer player, String id) {
        CompoundTag data = player.getPersistentData();
        Skill skill = this.GetSkill(id);
        if (skill == null) {
            return 0;
        }
        String key = id.toLowerCase() + SKILL_LEVEL_SIGNATURE;
        return data.getInt(key);
    }
}

