/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.xp;

import com.google.gson.JsonObject;
import com.tyzsskills.server.active.AttributeRegistry;
import com.tyzsskills.server.active.LevelManager;
import com.tyzsskills.server.active.SpManager;
import com.tyzsskills.server.attachments.StatsTracker;
import com.tyzsskills.server.payloads.LevelToastPayload;
import com.tyzsskills.server.payloads.StatsSpEarnedPayload;
import com.tyzsskills.server.payloads.StatsXpPayload;
import com.tyzsskills.server.payloads.XpUpdatePayload;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;

public class XpManager {
    private static final String dataKey = "SKILL_XP";
    private static final LevelData fallback = new LevelData(Float.MAX_VALUE, 0);
    private static final Map<Integer, LevelData> POOL = new HashMap<Integer, LevelData>();

    public static void LoadPool(JsonObject obj) {
        for (String key : obj.keySet()) {
            try {
                int reward;
                int level = Integer.parseInt(key);
                JsonObject data = obj.getAsJsonObject(key);
                float goal = data.has("goal") ? data.get("goal").getAsFloat() : fallback.goal();
                int n = reward = data.has("reward") ? data.get("reward").getAsInt() : fallback.reward();
                if (goal <= 0.0f || reward < 0 || level < -1) continue;
                POOL.put(level, new LevelData(goal, reward));
            }
            catch (Exception ex) {}
        }
    }

    private static void SetXPInternal(ServerPlayer player, float amount, float gains) {
        if (amount < 0.0f) {
            return;
        }
        CompoundTag data = player.getPersistentData();
        data.putFloat(dataKey, amount);
        XpManager.LevelUpCheck(player);
        XpManager.UpdateClient(player, gains);
        if (gains > 0.0f) {
            ((StatsTracker)player.getData(StatsTracker.DATA)).addXp(gains);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new StatsXpPayload(gains), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void SetXP(ServerPlayer player, float amount) {
        XpManager.SetXPInternal(player, amount, 0.0f);
    }

    public static void AddXP(ServerPlayer player, float amount) {
        if (amount <= 0.0f) {
            return;
        }
        XpManager.SetXPInternal(player, XpManager.GetXP(player) + amount, amount);
    }

    public static void RemoveXP(ServerPlayer player, float amount) {
        if (amount <= 0.0f) {
            return;
        }
        float result = Math.max(0.0f, XpManager.GetXP(player) - amount);
        XpManager.SetXPInternal(player, result, 0.0f);
    }

    public static void RestorePlayerXPData(ServerPlayer oldPlayer, ServerPlayer newPlayer) {
        CompoundTag oldData = oldPlayer.getPersistentData();
        CompoundTag newData = newPlayer.getPersistentData();
        if (oldData.contains(dataKey)) {
            newData.putFloat(dataKey, oldData.getFloat(dataKey));
            XpManager.UpdateClient(newPlayer, 0.0f);
        } else {
            XpManager.SetXP(newPlayer, 0.0f);
        }
    }

    public static void ClearPool() {
        POOL.clear();
    }

    private static void UpdateClient(ServerPlayer player, float gains) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new XpUpdatePayload(XpManager.GetXP(player), gains), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void LevelUpCheck(ServerPlayer player) {
        LevelData data;
        int currentLevel = LevelManager.GetLevel(player);
        float currentXp = XpManager.GetXP(player);
        int spBuffer = 0;
        int levelBuffer = 0;
        boolean flag = false;
        double multiplierAttribute = player.getAttributeValue(AttributeRegistry.SP_MULTIPLIER);
        while (currentXp >= (data = XpManager.GetLevelData(currentLevel)).goal()) {
            currentXp -= data.goal();
            flag = true;
            ++currentLevel;
            ++levelBuffer;
            long spGains = Math.round((double)data.reward() * multiplierAttribute);
            spBuffer += (int)Math.max(spGains, 1L);
        }
        if (flag && spBuffer > 0) {
            SpManager.AddSP(player, spBuffer);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new StatsSpEarnedPayload(spBuffer), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ((StatsTracker)player.getData(StatsTracker.DATA)).addSpEarned(spBuffer);
        }
        if (levelBuffer > 0) {
            LevelManager.AddLevel(player, levelBuffer);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new LevelToastPayload(currentLevel, spBuffer), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        player.getPersistentData().putFloat(dataKey, currentXp);
    }

    public static float GetXP(ServerPlayer player) {
        return player.getPersistentData().getFloat(dataKey);
    }

    public static LevelData GetLevelData(int lvl) {
        if (POOL.containsKey(lvl)) {
            return POOL.get(lvl);
        }
        if (POOL.containsKey(-1)) {
            return POOL.get(-1);
        }
        return fallback;
    }

    public record LevelData(float goal, int reward) {
    }
}

