/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.xp.xpEvents;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tyzsskills.server.active.AttributeRegistry;
import com.tyzsskills.server.active.ErrorManager;
import com.tyzsskills.server.xp.XpManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class XpBlock {
    private static final Map<String, Float> Xpvalues = new HashMap<String, Float>();
    private static final Map<TagKey<Block>, Float> XpTagValues = new HashMap<TagKey<Block>, Float>();
    private static final Map<Block, Float> CACHE = new HashMap<Block, Float>();

    public static void LoadValues(JsonObject source) {
        for (String categoryKey : source.keySet()) {
            JsonObject category = source.getAsJsonObject(categoryKey);
            if (!category.has("xp")) {
                ErrorManager.RegisterLoadError("loading '" + categoryKey + "' in block xp values", "Missing 'xp' value");
                continue;
            }
            if (!category.has("blocks")) {
                ErrorManager.RegisterLoadError("loading '" + categoryKey + "' in block xp values", "Missing 'block' list");
                continue;
            }
            float xpValue = category.get("xp").getAsFloat();
            for (JsonElement iteration : category.getAsJsonArray("blocks")) {
                String entry = iteration.getAsString();
                if (entry.startsWith("#")) {
                    String tag = entry.substring(1);
                    try {
                        ResourceLocation location = ResourceLocation.parse((String)tag);
                        TagKey tagKey = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)location);
                        XpTagValues.put((TagKey<Block>)tagKey, Float.valueOf(xpValue));
                    }
                    catch (Exception ex) {
                        System.err.println("TyzSkills: Error when loading tags '" + entry + "' : " + ex.getMessage());
                        ErrorManager.RegisterLoadError("parsing block/tag '" + entry + "' in block xp values", "Invalid ResourceLocation format");
                    }
                    continue;
                }
                Xpvalues.put(entry, Float.valueOf(xpValue));
            }
        }
    }

    public static void ClearValues() {
        Xpvalues.clear();
        XpTagValues.clear();
        CACHE.clear();
    }

    public static void BlockBreakProfit(BlockState state, ServerPlayer player) {
        CropBlock crop;
        Block block = state.getBlock();
        if (block instanceof CropBlock ? !(crop = (CropBlock)block).isMaxAge(state) : state.getBlock() instanceof NetherWartBlock && (Integer)state.getValue((Property)NetherWartBlock.AGE) < 3) {
            return;
        }
        float amount = XpBlock.GetBlockValue(state) * (float)player.getAttributeValue(AttributeRegistry.SKILL_XP_MULTIPLIER);
        if (amount > 0.0f) {
            XpManager.AddXP(player, amount);
        }
    }

    public static float GetBlockValue(BlockState state) {
        Block block = state.getBlock();
        if (CACHE.containsKey(block)) {
            return CACHE.get(block).floatValue();
        }
        String blockID = BuiltInRegistries.BLOCK.getKey((Object)block).toString();
        float cacheValue = 0.0f;
        if (Xpvalues.containsKey(blockID)) {
            cacheValue = Xpvalues.get(blockID).floatValue();
        } else {
            for (Map.Entry<TagKey<Block>, Float> entry : XpTagValues.entrySet()) {
                if (!state.is(entry.getKey())) continue;
                cacheValue = entry.getValue().floatValue();
                break;
            }
        }
        CACHE.put(block, Float.valueOf(cacheValue));
        return cacheValue;
    }
}

