/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.xp.xpEvents;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tyzsskills.server.active.AttributeRegistry;
import com.tyzsskills.server.active.ErrorManager;
import com.tyzsskills.server.xp.XpManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class XpEntity {
    public static Map<String, Float> Xpvalues = new HashMap<String, Float>();
    public static Map<TagKey<EntityType<?>>, Float> XpTagValues = new HashMap();
    public static Map<EntityType<?>, Float> CACHE = new HashMap();

    public static void LoadValues(JsonObject source) {
        for (String categoryKey : source.keySet()) {
            JsonObject category = source.getAsJsonObject(categoryKey);
            if (!category.has("xp")) {
                ErrorManager.RegisterLoadError("loading '" + categoryKey + "' in entity xp values", "Missing 'xp' value");
                continue;
            }
            if (!category.has("entities")) {
                ErrorManager.RegisterLoadError("loading '" + categoryKey + "' in entity xp values", "Missing 'entity' list");
                continue;
            }
            float xpValue = category.get("xp").getAsFloat();
            for (JsonElement iteration : category.getAsJsonArray("entities")) {
                String entry = iteration.getAsString();
                if (entry.startsWith("#")) {
                    String tag = entry.substring(1);
                    try {
                        ResourceLocation location = ResourceLocation.parse((String)tag);
                        TagKey tagKey = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)location);
                        XpTagValues.put(tagKey, Float.valueOf(xpValue));
                    }
                    catch (Exception ex) {
                        System.err.println("TyzSkills: Error when loading tags '" + entry + "' : " + ex.getMessage());
                        ErrorManager.RegisterLoadError("parsing entity/tag '" + entry + "' in entity xp values", "Invalid ResourceLocation format");
                    }
                    continue;
                }
                Xpvalues.put(entry, Float.valueOf(xpValue));
            }
        }
    }

    public static void ClearValues() {
        Xpvalues.clear();
        XpTagValues.clear();
        CACHE.clear();
    }

    public static void EntityKillProfit(Entity entity, ServerPlayer player) {
        float amount = XpEntity.GetEntityValue(entity) * (float)player.getAttributeValue(AttributeRegistry.SKILL_XP_MULTIPLIER);
        if (amount > 0.0f) {
            XpManager.AddXP(player, amount);
        }
    }

    public static boolean AreValuesLoaded() {
        return !Xpvalues.isEmpty() || !XpTagValues.isEmpty();
    }

    public static float GetEntityValue(Entity entity) {
        EntityType type = entity.getType();
        if (CACHE.containsKey(type)) {
            return CACHE.get(type).floatValue();
        }
        String entityID = BuiltInRegistries.ENTITY_TYPE.getKey((Object)type).toString();
        float cacheValue = 0.0f;
        if (Xpvalues.containsKey(entityID)) {
            cacheValue = Xpvalues.get(entityID).floatValue();
        } else {
            for (Map.Entry<TagKey<EntityType<?>>, Float> entry : XpTagValues.entrySet()) {
                if (!type.is(entry.getKey())) continue;
                cacheValue = entry.getValue().floatValue();
                break;
            }
        }
        CACHE.put(type, Float.valueOf(cacheValue));
        return cacheValue;
    }
}

