/*
 * Decompiled with CFR 0.152.
 */
package com.tyzsskills.server.xp.xpEvents;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tyzsskills.server.active.AttributeRegistry;
import com.tyzsskills.server.active.ErrorManager;
import com.tyzsskills.server.xp.XpManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class XpFood {
    private static final Map<String, Float> xpValues = new HashMap<String, Float>();
    private static final Map<Item, Float> CACHE = new HashMap<Item, Float>();

    public static void LoadValues(JsonObject source) {
        for (String categoryKey : source.keySet()) {
            JsonObject category = source.getAsJsonObject(categoryKey);
            if (!category.has("xp")) {
                ErrorManager.RegisterLoadError("loading '" + categoryKey + "' in food xp values", "Missing 'xp' value");
                continue;
            }
            if (!category.has("food")) {
                ErrorManager.RegisterLoadError("loading '" + categoryKey + "' in food xp values", "Missing 'food' list");
                continue;
            }
            float xpValue = category.get("xp").getAsFloat();
            for (JsonElement iteration : category.getAsJsonArray("food")) {
                String entry = iteration.getAsString();
                xpValues.put(entry, Float.valueOf(xpValue));
            }
        }
    }

    public static void ClearValues() {
        xpValues.clear();
        CACHE.clear();
    }

    public static void FoodEatProfit(ItemStack itemStack, ServerPlayer player) {
        float amount = XpFood.GetFoodValue(itemStack, player) * (float)player.getAttributeValue(AttributeRegistry.SKILL_XP_MULTIPLIER);
        if (amount > 0.0f) {
            XpManager.AddXP(player, amount);
        }
    }

    public static float GetFoodValue(ItemStack itemStack, ServerPlayer player) {
        Item item = itemStack.getItem();
        if (CACHE.containsKey(item)) {
            return CACHE.get(item).floatValue();
        }
        String itemId = BuiltInRegistries.ITEM.getKey((Object)item).toString();
        float cacheValue = 0.0f;
        if (xpValues.containsKey(itemId)) {
            cacheValue = xpValues.get(itemId).floatValue();
        } else {
            FoodProperties itemStats = item.getFoodProperties(itemStack, (LivingEntity)player);
            if (itemStats == null) {
                return 1.0f;
            }
            int itemNutrition = itemStats.nutrition();
            float itemSaturation = itemStats.saturation();
            cacheValue = (float)itemNutrition + itemSaturation;
        }
        CACHE.put(item, Float.valueOf(cacheValue));
        return cacheValue;
    }
}

