/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.tyzsskills;

import io.netty.buffer.Unpooled;
import java.util.function.Supplier;
import net.mcreator.tyzsskills.client.gui.CombatguiScreen;
import net.mcreator.tyzsskills.client.gui.NewmainguiScreen;
import net.mcreator.tyzsskills.client.gui.OtherguiScreen;
import net.mcreator.tyzsskills.client.gui.SpecialguiScreen;
import net.mcreator.tyzsskills.world.inventory.CombatguiMenu;
import net.mcreator.tyzsskills.world.inventory.NewmainguiMenu;
import net.mcreator.tyzsskills.world.inventory.OtherguiMenu;
import net.mcreator.tyzsskills.world.inventory.SpecialguiMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class OpenGuiPacket {
    private final BlockPos pos;
    private final GuiType guiType;

    public OpenGuiPacket(BlockPos pos, GuiType guiType) {
        this.pos = pos;
        this.guiType = guiType;
    }

    public OpenGuiPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.guiType = (GuiType)buf.m_130066_(GuiType.class);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130068_((Enum)this.guiType);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getDirection().getReceptionSide().isClient()) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.refreshOrOpenGui(this.pos, this.guiType));
            }
        });
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void refreshOrOpenGui(BlockPos pos, GuiType guiType) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        mc.execute(() -> {
            Inventory inventory = mc.f_91074_.m_150109_();
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.m_130064_(pos);
            switch (guiType) {
                case MAIN: {
                    Screen patt2479$temp = mc.f_91080_;
                    if (patt2479$temp instanceof NewmainguiScreen) {
                        NewmainguiScreen screen = (NewmainguiScreen)patt2479$temp;
                        screen.refreshGui();
                        break;
                    }
                    NewmainguiMenu menu = new NewmainguiMenu(0, inventory, buf);
                    mc.m_91152_((Screen)new NewmainguiScreen(menu, inventory, (Component)Component.m_237113_((String)"Tyz's GUI")));
                    break;
                }
                case COMBAT: {
                    Screen patt2860$temp = mc.f_91080_;
                    if (patt2860$temp instanceof CombatguiScreen) {
                        CombatguiScreen screen = (CombatguiScreen)patt2860$temp;
                        screen.refreshGui();
                        break;
                    }
                    CombatguiMenu menu = new CombatguiMenu(0, inventory, buf);
                    mc.m_91152_((Screen)new CombatguiScreen(menu, inventory, (Component)Component.m_237113_((String)"Combat")));
                    break;
                }
                case OTHER: {
                    Screen patt3233$temp = mc.f_91080_;
                    if (patt3233$temp instanceof OtherguiScreen) {
                        OtherguiScreen screen = (OtherguiScreen)patt3233$temp;
                        screen.refreshGui();
                        break;
                    }
                    OtherguiMenu menu = new OtherguiMenu(0, inventory, buf);
                    mc.m_91152_((Screen)new OtherguiScreen(menu, inventory, (Component)Component.m_237113_((String)"Autres")));
                    break;
                }
                case SPECIAL: {
                    Screen patt3604$temp = mc.f_91080_;
                    if (patt3604$temp instanceof SpecialguiScreen) {
                        SpecialguiScreen screen = (SpecialguiScreen)patt3604$temp;
                        screen.refreshGui();
                        break;
                    }
                    SpecialguiMenu menu = new SpecialguiMenu(0, inventory, buf);
                    mc.m_91152_((Screen)new SpecialguiScreen(menu, inventory, (Component)Component.m_237113_((String)"Sp\u00e9cial")));
                }
            }
        });
    }

    public static enum GuiType {
        MAIN,
        COMBAT,
        OTHER,
        SPECIAL;

    }
}

