/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.tyzsskills.network;

import java.util.function.Supplier;
import net.mcreator.tyzsskills.TyzsSkillsMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TyzsSkillsModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        TyzsSkillsMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.Level = message.data.Level;
                    variables.researchpoints = message.data.researchpoints;
                    variables.Skill_XP = message.data.Skill_XP;
                    variables.maxskillxp = message.data.maxskillxp;
                    variables.block_reach_lvl = message.data.block_reach_lvl;
                    variables.attack_damage_lvl = message.data.attack_damage_lvl;
                    variables.max_health_lvl = message.data.max_health_lvl;
                    variables.venomous_attack_lvl = message.data.venomous_attack_lvl;
                    variables.second_life_lvl = message.data.second_life_lvl;
                    variables.xp_boost_lvl = message.data.xp_boost_lvl;
                    variables.Villager_follow_lvl = message.data.Villager_follow_lvl;
                    variables.night_vision_lvl = message.data.night_vision_lvl;
                    variables.damage_deal_lvl = message.data.damage_deal_lvl;
                    variables.resistance_lvl = message.data.resistance_lvl;
                    variables.fire_resistance_lvl = message.data.fire_resistance_lvl;
                    variables.skill_xp_boost_lvl = message.data.skill_xp_boost_lvl;
                    variables.lifetime_xp = message.data.lifetime_xp;
                    variables.earned_points = message.data.earned_points;
                    variables.spent_points = message.data.spent_points;
                    variables.owned_skills = message.data.owned_skills;
                    variables.critical_hit_lvl = message.data.critical_hit_lvl;
                    variables.friendly_piglins = message.data.friendly_piglins;
                    variables.restaured_hunger_lvl = message.data.restaured_hunger_lvl;
                    variables.comestible_rotten_flesh_lvl = message.data.comestible_rotten_flesh_lvl;
                    variables.harvester_lvl = message.data.harvester_lvl;
                    variables.swim_speed = message.data.swim_speed;
                    variables.speed_lvl = message.data.speed_lvl;
                    variables.step_height_lvl = message.data.step_height_lvl;
                    variables.badge_level_lvl = message.data.badge_level_lvl;
                    variables.badge_level_all_skills = message.data.badge_level_all_skills;
                    variables.badge_block_xp = message.data.badge_block_xp;
                    variables.Block_breaking_xp = message.data.Block_breaking_xp;
                    variables.badge_entity = message.data.badge_entity;
                    variables.entities_killing_xp = message.data.entities_killing_xp;
                    variables.badge_eating = message.data.badge_eating;
                    variables.eating_xp = message.data.eating_xp;
                    variables.badge_craft = message.data.badge_craft;
                    variables.craft_xp = message.data.craft_xp;
                    variables.badge_all_the_ways = message.data.badge_all_the_ways;
                    variables.way_1 = message.data.way_1;
                    variables.way_2 = message.data.way_2;
                    variables.way_3 = message.data.way_3;
                    variables.way_4 = message.data.way_4;
                    variables.way_5 = message.data.way_5;
                    variables.way_6 = message.data.way_6;
                    variables.way_7 = message.data.way_7;
                    variables.way_8 = message.data.way_8;
                    variables.used_ways = message.data.used_ways;
                    variables.badges_badges = message.data.badges_badges;
                    variables.used_badges = message.data.used_badges;
                    variables.XP_multiplier = message.data.XP_multiplier;
                    variables.bloodlust_lv = message.data.bloodlust_lv;
                    variables.Updated = message.data.Updated;
                    variables.openguiA = message.data.openguiA;
                    variables.openguiF = message.data.openguiF;
                    variables.openguiM = message.data.openguiM;
                    variables.openguiS = message.data.openguiS;
                    variables.magnet_lvl = message.data.magnet_lvl;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double Level = 1.0;
        public double researchpoints = 0.0;
        public double Skill_XP = 0.0;
        public double maxskillxp = 100.0;
        public double block_reach_lvl = 0.0;
        public double attack_damage_lvl = 0.0;
        public double max_health_lvl = 0.0;
        public double venomous_attack_lvl = 0.0;
        public double second_life_lvl = 0.0;
        public double xp_boost_lvl = 0.0;
        public double Villager_follow_lvl = 0.0;
        public double night_vision_lvl = 0.0;
        public double damage_deal_lvl = 0.0;
        public double resistance_lvl = 0.0;
        public double fire_resistance_lvl = 0.0;
        public double skill_xp_boost_lvl = 0.0;
        public double lifetime_xp = 0.0;
        public double earned_points = 0.0;
        public double spent_points = 0.0;
        public double owned_skills = 0.0;
        public double critical_hit_lvl = 0.0;
        public double friendly_piglins = 0.0;
        public double restaured_hunger_lvl = 0.0;
        public double comestible_rotten_flesh_lvl = 0.0;
        public double harvester_lvl = 0.0;
        public double swim_speed = 0.0;
        public double speed_lvl = 0.0;
        public double step_height_lvl = 0.0;
        public double badge_level_lvl = 0.0;
        public double badge_level_all_skills = 0.0;
        public double badge_block_xp = 0.0;
        public double Block_breaking_xp = 0.0;
        public double badge_entity = 0.0;
        public double entities_killing_xp = 0.0;
        public double badge_eating = 0.0;
        public double eating_xp = 0.0;
        public double badge_craft = 0.0;
        public double craft_xp = 0.0;
        public double badge_all_the_ways = 0.0;
        public boolean way_1 = false;
        public boolean way_2 = false;
        public boolean way_3 = false;
        public boolean way_4 = false;
        public boolean way_5 = false;
        public boolean way_6 = false;
        public boolean way_7 = false;
        public boolean way_8 = false;
        public double used_ways = 0.0;
        public double badges_badges = 0.0;
        public double used_badges = 0.0;
        public double XP_multiplier = 1.0;
        public double bloodlust_lv = 0.0;
        public boolean Updated = false;
        public boolean openguiA = false;
        public boolean openguiF = false;
        public boolean openguiM = false;
        public boolean openguiS = false;
        public double magnet_lvl = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                TyzsSkillsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("Level", this.Level);
            nbt.m_128347_("researchpoints", this.researchpoints);
            nbt.m_128347_("Skill_XP", this.Skill_XP);
            nbt.m_128347_("maxskillxp", this.maxskillxp);
            nbt.m_128347_("block_reach_lvl", this.block_reach_lvl);
            nbt.m_128347_("attack_damage_lvl", this.attack_damage_lvl);
            nbt.m_128347_("max_health_lvl", this.max_health_lvl);
            nbt.m_128347_("venomous_attack_lvl", this.venomous_attack_lvl);
            nbt.m_128347_("second_life_lvl", this.second_life_lvl);
            nbt.m_128347_("xp_boost_lvl", this.xp_boost_lvl);
            nbt.m_128347_("Villager_follow_lvl", this.Villager_follow_lvl);
            nbt.m_128347_("night_vision_lvl", this.night_vision_lvl);
            nbt.m_128347_("damage_deal_lvl", this.damage_deal_lvl);
            nbt.m_128347_("resistance_lvl", this.resistance_lvl);
            nbt.m_128347_("fire_resistance_lvl", this.fire_resistance_lvl);
            nbt.m_128347_("skill_xp_boost_lvl", this.skill_xp_boost_lvl);
            nbt.m_128347_("lifetime_xp", this.lifetime_xp);
            nbt.m_128347_("earned_points", this.earned_points);
            nbt.m_128347_("spent_points", this.spent_points);
            nbt.m_128347_("owned_skills", this.owned_skills);
            nbt.m_128347_("critical_hit_lvl", this.critical_hit_lvl);
            nbt.m_128347_("friendly_piglins", this.friendly_piglins);
            nbt.m_128347_("restaured_hunger_lvl", this.restaured_hunger_lvl);
            nbt.m_128347_("comestible_rotten_flesh_lvl", this.comestible_rotten_flesh_lvl);
            nbt.m_128347_("harvester_lvl", this.harvester_lvl);
            nbt.m_128347_("swim_speed", this.swim_speed);
            nbt.m_128347_("speed_lvl", this.speed_lvl);
            nbt.m_128347_("step_height_lvl", this.step_height_lvl);
            nbt.m_128347_("badge_level_lvl", this.badge_level_lvl);
            nbt.m_128347_("badge_level_all_skills", this.badge_level_all_skills);
            nbt.m_128347_("badge_block_xp", this.badge_block_xp);
            nbt.m_128347_("Block_breaking_xp", this.Block_breaking_xp);
            nbt.m_128347_("badge_entity", this.badge_entity);
            nbt.m_128347_("entities_killing_xp", this.entities_killing_xp);
            nbt.m_128347_("badge_eating", this.badge_eating);
            nbt.m_128347_("eating_xp", this.eating_xp);
            nbt.m_128347_("badge_craft", this.badge_craft);
            nbt.m_128347_("craft_xp", this.craft_xp);
            nbt.m_128347_("badge_all_the_ways", this.badge_all_the_ways);
            nbt.m_128379_("way_1", this.way_1);
            nbt.m_128379_("way_2", this.way_2);
            nbt.m_128379_("way_3", this.way_3);
            nbt.m_128379_("way_4", this.way_4);
            nbt.m_128379_("way_5", this.way_5);
            nbt.m_128379_("way_6", this.way_6);
            nbt.m_128379_("way_7", this.way_7);
            nbt.m_128379_("way_8", this.way_8);
            nbt.m_128347_("used_ways", this.used_ways);
            nbt.m_128347_("badges_badges", this.badges_badges);
            nbt.m_128347_("used_badges", this.used_badges);
            nbt.m_128347_("XP_multiplier", this.XP_multiplier);
            nbt.m_128347_("bloodlust_lv", this.bloodlust_lv);
            nbt.m_128379_("Updated", this.Updated);
            nbt.m_128379_("openguiA", this.openguiA);
            nbt.m_128379_("openguiF", this.openguiF);
            nbt.m_128379_("openguiM", this.openguiM);
            nbt.m_128379_("openguiS", this.openguiS);
            nbt.m_128347_("magnet_lvl", this.magnet_lvl);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.Level = nbt.m_128459_("Level");
            this.researchpoints = nbt.m_128459_("researchpoints");
            this.Skill_XP = nbt.m_128459_("Skill_XP");
            this.maxskillxp = nbt.m_128459_("maxskillxp");
            this.block_reach_lvl = nbt.m_128459_("block_reach_lvl");
            this.attack_damage_lvl = nbt.m_128459_("attack_damage_lvl");
            this.max_health_lvl = nbt.m_128459_("max_health_lvl");
            this.venomous_attack_lvl = nbt.m_128459_("venomous_attack_lvl");
            this.second_life_lvl = nbt.m_128459_("second_life_lvl");
            this.xp_boost_lvl = nbt.m_128459_("xp_boost_lvl");
            this.Villager_follow_lvl = nbt.m_128459_("Villager_follow_lvl");
            this.night_vision_lvl = nbt.m_128459_("night_vision_lvl");
            this.damage_deal_lvl = nbt.m_128459_("damage_deal_lvl");
            this.resistance_lvl = nbt.m_128459_("resistance_lvl");
            this.fire_resistance_lvl = nbt.m_128459_("fire_resistance_lvl");
            this.skill_xp_boost_lvl = nbt.m_128459_("skill_xp_boost_lvl");
            this.lifetime_xp = nbt.m_128459_("lifetime_xp");
            this.earned_points = nbt.m_128459_("earned_points");
            this.spent_points = nbt.m_128459_("spent_points");
            this.owned_skills = nbt.m_128459_("owned_skills");
            this.critical_hit_lvl = nbt.m_128459_("critical_hit_lvl");
            this.friendly_piglins = nbt.m_128459_("friendly_piglins");
            this.restaured_hunger_lvl = nbt.m_128459_("restaured_hunger_lvl");
            this.comestible_rotten_flesh_lvl = nbt.m_128459_("comestible_rotten_flesh_lvl");
            this.harvester_lvl = nbt.m_128459_("harvester_lvl");
            this.swim_speed = nbt.m_128459_("swim_speed");
            this.speed_lvl = nbt.m_128459_("speed_lvl");
            this.step_height_lvl = nbt.m_128459_("step_height_lvl");
            this.badge_level_lvl = nbt.m_128459_("badge_level_lvl");
            this.badge_level_all_skills = nbt.m_128459_("badge_level_all_skills");
            this.badge_block_xp = nbt.m_128459_("badge_block_xp");
            this.Block_breaking_xp = nbt.m_128459_("Block_breaking_xp");
            this.badge_entity = nbt.m_128459_("badge_entity");
            this.entities_killing_xp = nbt.m_128459_("entities_killing_xp");
            this.badge_eating = nbt.m_128459_("badge_eating");
            this.eating_xp = nbt.m_128459_("eating_xp");
            this.badge_craft = nbt.m_128459_("badge_craft");
            this.craft_xp = nbt.m_128459_("craft_xp");
            this.badge_all_the_ways = nbt.m_128459_("badge_all_the_ways");
            this.way_1 = nbt.m_128471_("way_1");
            this.way_2 = nbt.m_128471_("way_2");
            this.way_3 = nbt.m_128471_("way_3");
            this.way_4 = nbt.m_128471_("way_4");
            this.way_5 = nbt.m_128471_("way_5");
            this.way_6 = nbt.m_128471_("way_6");
            this.way_7 = nbt.m_128471_("way_7");
            this.way_8 = nbt.m_128471_("way_8");
            this.used_ways = nbt.m_128459_("used_ways");
            this.badges_badges = nbt.m_128459_("badges_badges");
            this.used_badges = nbt.m_128459_("used_badges");
            this.XP_multiplier = nbt.m_128459_("XP_multiplier");
            this.bloodlust_lv = nbt.m_128459_("bloodlust_lv");
            this.Updated = nbt.m_128471_("Updated");
            this.openguiA = nbt.m_128471_("openguiA");
            this.openguiF = nbt.m_128471_("openguiF");
            this.openguiM = nbt.m_128471_("openguiM");
            this.openguiS = nbt.m_128471_("openguiS");
            this.magnet_lvl = nbt.m_128459_("magnet_lvl");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("tyzs_skills", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.Level = original.Level;
            clone.researchpoints = original.researchpoints;
            clone.Skill_XP = original.Skill_XP;
            clone.maxskillxp = original.maxskillxp;
            clone.block_reach_lvl = original.block_reach_lvl;
            clone.attack_damage_lvl = original.attack_damage_lvl;
            clone.max_health_lvl = original.max_health_lvl;
            clone.venomous_attack_lvl = original.venomous_attack_lvl;
            clone.second_life_lvl = original.second_life_lvl;
            clone.xp_boost_lvl = original.xp_boost_lvl;
            clone.Villager_follow_lvl = original.Villager_follow_lvl;
            clone.night_vision_lvl = original.night_vision_lvl;
            clone.damage_deal_lvl = original.damage_deal_lvl;
            clone.resistance_lvl = original.resistance_lvl;
            clone.fire_resistance_lvl = original.fire_resistance_lvl;
            clone.skill_xp_boost_lvl = original.skill_xp_boost_lvl;
            clone.lifetime_xp = original.lifetime_xp;
            clone.earned_points = original.earned_points;
            clone.spent_points = original.spent_points;
            clone.owned_skills = original.owned_skills;
            clone.critical_hit_lvl = original.critical_hit_lvl;
            clone.friendly_piglins = original.friendly_piglins;
            clone.restaured_hunger_lvl = original.restaured_hunger_lvl;
            clone.comestible_rotten_flesh_lvl = original.comestible_rotten_flesh_lvl;
            clone.harvester_lvl = original.harvester_lvl;
            clone.swim_speed = original.swim_speed;
            clone.speed_lvl = original.speed_lvl;
            clone.step_height_lvl = original.step_height_lvl;
            clone.badge_level_lvl = original.badge_level_lvl;
            clone.badge_level_all_skills = original.badge_level_all_skills;
            clone.badge_block_xp = original.badge_block_xp;
            clone.Block_breaking_xp = original.Block_breaking_xp;
            clone.badge_entity = original.badge_entity;
            clone.entities_killing_xp = original.entities_killing_xp;
            clone.badge_eating = original.badge_eating;
            clone.eating_xp = original.eating_xp;
            clone.badge_craft = original.badge_craft;
            clone.craft_xp = original.craft_xp;
            clone.badge_all_the_ways = original.badge_all_the_ways;
            clone.way_1 = original.way_1;
            clone.way_2 = original.way_2;
            clone.way_3 = original.way_3;
            clone.way_4 = original.way_4;
            clone.way_5 = original.way_5;
            clone.way_6 = original.way_6;
            clone.way_7 = original.way_7;
            clone.way_8 = original.way_8;
            clone.used_ways = original.used_ways;
            clone.badges_badges = original.badges_badges;
            clone.used_badges = original.used_badges;
            clone.XP_multiplier = original.XP_multiplier;
            clone.bloodlust_lv = original.bloodlust_lv;
            clone.Updated = original.Updated;
            clone.openguiA = original.openguiA;
            clone.openguiF = original.openguiF;
            clone.openguiM = original.openguiM;
            clone.openguiS = original.openguiS;
            clone.magnet_lvl = original.magnet_lvl;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }
    }
}

