/*
 * Decompiled with CFR 0.152.
 */
package com.chan1.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.architectury.platform.Platform;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class InsightConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = Platform.getConfigFolder().resolve("insight.json");
    private static ConfigData data = new ConfigData();

    public static boolean isItemTooltipsEnabled() {
        return InsightConfig.data.itemTooltipsEnabled;
    }

    public static void setItemTooltipsEnabled(boolean enabled) {
        InsightConfig.data.itemTooltipsEnabled = enabled;
    }

    public static boolean isTargetHudEnabled() {
        return InsightConfig.data.targetHudEnabled;
    }

    public static void setTargetHudEnabled(boolean enabled) {
        InsightConfig.data.targetHudEnabled = enabled;
    }

    public static boolean isBedTimerEnabled() {
        return InsightConfig.data.bedTimerEnabled;
    }

    public static void setBedTimerEnabled(boolean enabled) {
        InsightConfig.data.bedTimerEnabled = enabled;
    }

    public static boolean isCropGrowthEnabled() {
        return InsightConfig.data.cropGrowthEnabled;
    }

    public static void setCropGrowthEnabled(boolean enabled) {
        InsightConfig.data.cropGrowthEnabled = enabled;
    }

    public static boolean isTargetHudSmartPositioning() {
        return InsightConfig.data.targetHudSmartPositioning;
    }

    public static void setTargetHudSmartPositioning(boolean enabled) {
        InsightConfig.data.targetHudSmartPositioning = enabled;
    }

    public static DetectionMode getDetectionMode() {
        return InsightConfig.data.detectionMode;
    }

    public static void setDetectionMode(DetectionMode mode) {
        InsightConfig.data.detectionMode = mode;
    }

    public static int getMaxDisplayedTooltips() {
        return InsightConfig.data.maxDisplayedTooltips;
    }

    public static void setMaxDisplayedTooltips(int max) {
        InsightConfig.data.maxDisplayedTooltips = max;
    }

    public static double getDetectionRange() {
        return 4.5;
    }

    public static double getTooltipYOffset() {
        return InsightConfig.data.tooltipYOffset;
    }

    public static void setTooltipYOffset(double offset) {
        InsightConfig.data.tooltipYOffset = offset;
    }

    public static double getMaxRenderDistance() {
        return InsightConfig.data.maxRenderDistance;
    }

    public static void setMaxRenderDistance(double distance) {
        InsightConfig.data.maxRenderDistance = distance;
    }

    public static float getBillboardScale() {
        return InsightConfig.data.billboardScale;
    }

    public static void setBillboardScale(float scale) {
        InsightConfig.data.billboardScale = scale;
    }

    public static boolean isAnimationsEnabled() {
        return InsightConfig.data.animationsEnabled;
    }

    public static void setAnimationsEnabled(boolean enabled) {
        InsightConfig.data.animationsEnabled = enabled;
    }

    public static int getAnimationDurationMs() {
        return InsightConfig.data.animationDurationMs;
    }

    public static void setAnimationDurationMs(int durationMs) {
        InsightConfig.data.animationDurationMs = durationMs;
    }

    public static void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                data = (ConfigData)GSON.fromJson(json, ConfigData.class);
                if (data == null) {
                    data = new ConfigData();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                data = new ConfigData();
            }
        }
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)data), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private InsightConfig() {
    }

    public static class ConfigData {
        public boolean itemTooltipsEnabled = true;
        public boolean targetHudEnabled = true;
        public boolean bedTimerEnabled = true;
        public boolean cropGrowthEnabled = true;
        public boolean targetHudSmartPositioning = true;
        public double tooltipYOffset = 0.5;
        public double maxRenderDistance = 8.0;
        public float billboardScale = 0.016f;
        public boolean animationsEnabled = true;
        public int animationDurationMs = 150;
        public DetectionMode detectionMode = DetectionMode.AREA;
        public int maxDisplayedTooltips = 5;
    }

    public static enum DetectionMode {
        AREA,
        CROSSHAIR;

    }
}

