/*
 * Decompiled with CFR 0.152.
 */
package com.chan1.client.feature.items;

import com.chan1.client.config.InsightConfig;
import com.chan1.client.feature.items.DroppedItemDetector;
import com.chan1.client.util.render.AnimationHelper;
import com.chan1.client.util.render.TooltipBackgroundRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public final class DroppedItemBillboardRenderer {
    private static final int LIGHT_FULL_BRIGHT = 0xF000F0;
    private static final float ICON_SIZE = 16.0f;
    private static final float ICON_PADDING = 2.0f;
    private static final int COUNT_COLOR = 0xBBBBBB;
    private static final float MAX_SCALE_MULTIPLIER = 1.0f;
    private static final float SCALE_START_DISTANCE = 3.0f;
    private static final AnimationHelper animationHelper = new AnimationHelper();

    private DroppedItemBillboardRenderer() {
    }

    public static void renderBillboards(PoseStack poseStack, MultiBufferSource bufferSource, Camera camera, float partialTick) {
        ItemEntity crosshairItem;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null || minecraft.f_91073_ == null || minecraft.f_91080_ != null) {
            return;
        }
        List<Object> items = InsightConfig.getDetectionMode() == InsightConfig.DetectionMode.CROSSHAIR ? ((crosshairItem = DroppedItemDetector.getCrosshairItem()) != null ? List.of(crosshairItem) : List.of()) : DroppedItemDetector.getNearbyItems();
        Vec3 cameraPos = camera.m_90583_();
        Vec3 cameraLookVec = new Vec3(camera.m_253058_());
        ArrayList<ItemWithDistance> sortedItems = new ArrayList<ItemWithDistance>();
        for (Object itemEntity : items) {
            Vec3 itemPos = DroppedItemBillboardRenderer.getInterpolatedPosition((ItemEntity)itemEntity, partialTick);
            Vec3 toItem = itemPos.m_82546_(cameraPos);
            double distance = toItem.m_82553_();
            if (toItem.m_82541_().m_82526_(cameraLookVec) < -0.2) continue;
            sortedItems.add(new ItemWithDistance((ItemEntity)itemEntity, distance, itemPos));
        }
        HashSet<Integer> currentEntityIds = new HashSet<Integer>();
        for (ItemWithDistance item : sortedItems) {
            currentEntityIds.add(item.entity().m_19879_());
        }
        animationHelper.cleanupStaleAnimations(currentEntityIds);
        if (sortedItems.isEmpty()) {
            return;
        }
        sortedItems.sort(Comparator.comparingDouble(ItemWithDistance::distance).reversed());
        if (bufferSource instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource source = (MultiBufferSource.BufferSource)bufferSource;
            source.m_109911_();
        }
        if (InsightConfig.isAnimationsEnabled()) {
            for (ItemWithDistance item : sortedItems) {
                animationHelper.getOrCreateAppearAnimation(item.entity().m_19879_());
            }
        }
        for (ItemWithDistance item : sortedItems) {
            AnimationHelper.AnimationState state;
            float animScale = 1.0f;
            if (InsightConfig.isAnimationsEnabled() && (state = animationHelper.getAnimationState(item.entity().m_19879_())) != null) {
                animScale = AnimationHelper.calculateScale(state, InsightConfig.getAnimationDurationMs());
            }
            if (!(animScale > 0.001f)) continue;
            DroppedItemBillboardRenderer.renderItemBillboard(poseStack, bufferSource, item.entity(), item.position(), item.distance(), cameraPos, camera, minecraft.f_91062_, animScale);
        }
    }

    private static void renderItemBillboard(PoseStack poseStack, MultiBufferSource bufferSource, ItemEntity itemEntity, Vec3 itemPos, double distance, Vec3 cameraPos, Camera camera, Font font, float animScale) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (distance > InsightConfig.getMaxRenderDistance()) {
            return;
        }
        float alpha = 1.0f;
        ItemStack itemStack = itemEntity.m_32055_();
        int stackCount = itemStack.m_41613_();
        Component titleLine = DroppedItemBillboardRenderer.buildTitleWithCount(itemStack, stackCount);
        List originalTooltip = itemStack.m_41651_((Player)minecraft.f_91074_, (TooltipFlag)(minecraft.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_));
        if (originalTooltip.isEmpty()) {
            return;
        }
        Vec3 billboardPos = itemPos.m_82520_(0.0, InsightConfig.getTooltipYOffset(), 0.0);
        float iconTotalWidth = 20.0f;
        int maxTextWidth = font.m_92852_((FormattedText)titleLine);
        for (int i = 1; i < originalTooltip.size(); ++i) {
            int width = font.m_92852_((FormattedText)originalTooltip.get(i));
            if (width <= maxTextWidth) continue;
            maxTextWidth = width;
        }
        int textAreaWidth = maxTextWidth + 6;
        int tooltipWidth = (int)iconTotalWidth + textAreaWidth;
        int tooltipHeight = 4 + originalTooltip.size() * 10;
        if (originalTooltip.size() > 1) {
            ++tooltipHeight;
        }
        tooltipHeight = Math.max(tooltipHeight, 18);
        poseStack.m_85836_();
        poseStack.m_85837_(billboardPos.f_82479_ - cameraPos.f_82479_, billboardPos.f_82480_ - cameraPos.f_82480_, billboardPos.f_82481_ - cameraPos.f_82481_);
        Quaternionf cameraRotation = camera.m_253121_();
        poseStack.m_252781_(cameraRotation);
        float baseScale = InsightConfig.getBillboardScale();
        float distanceScale = DroppedItemBillboardRenderer.calculateDistanceScale(distance);
        float scale = baseScale * distanceScale * animScale;
        poseStack.m_85841_(-scale, -scale, scale);
        float halfWidth = (float)tooltipWidth / 2.0f;
        float halfHeight = (float)tooltipHeight / 2.0f;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float left = -halfWidth - 3.0f;
        float top = -halfHeight - 3.0f;
        float right = halfWidth + 3.0f;
        float bottom = halfHeight + 3.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        TooltipBackgroundRenderer.renderNoStateChange(matrix, left, top, right, bottom, alpha);
        DroppedItemBillboardRenderer.renderItemIconNoStateChange(poseStack, bufferSource, itemStack, -halfWidth + 2.0f, -8.0f, alpha);
        int textAlpha = (int)(255.0f * alpha);
        float textStartX = -halfWidth + iconTotalWidth + 2.0f;
        float y = -halfHeight + 2.0f;
        MultiBufferSource.BufferSource immediateSource = minecraft.m_91269_().m_110104_();
        font.m_272077_(titleLine, textStartX, y, textAlpha << 24 | 0xFFFFFF, false, matrix, (MultiBufferSource)immediateSource, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        y += 10.0f;
        if (originalTooltip.size() > 1) {
            y += 1.0f;
        }
        for (int i = 1; i < originalTooltip.size(); ++i) {
            Component line = (Component)originalTooltip.get(i);
            font.m_272077_(line, textStartX, y, textAlpha << 24 | 0xAAAAAA, false, matrix, (MultiBufferSource)immediateSource, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
            y += 10.0f;
        }
        immediateSource.m_109911_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    private static Component buildTitleWithCount(ItemStack itemStack, int count) {
        MutableComponent name = itemStack.m_41786_().m_6881_();
        if (count > 1) {
            MutableComponent countText = Component.m_237113_((String)(" x" + count)).m_130948_(Style.f_131099_.m_178520_(0xBBBBBB));
            return name.m_7220_((Component)countText);
        }
        return name;
    }

    private static void renderItemIcon(PoseStack poseStack, MultiBufferSource bufferSource, ItemStack itemStack, float x, float y, float alpha) {
        Minecraft minecraft = Minecraft.m_91087_();
        ItemRenderer itemRenderer = minecraft.m_91291_();
        poseStack.m_85836_();
        poseStack.m_252880_(x + 8.0f, y + 8.0f, -0.01f);
        float iconScale = 14.0f;
        poseStack.m_85841_(iconScale, -iconScale, 0.001f);
        poseStack.m_85850_().m_252943_().identity();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableDepthTest();
        MultiBufferSource.BufferSource immediateSource = minecraft.m_91269_().m_110104_();
        itemRenderer.m_269128_(itemStack, ItemDisplayContext.GUI, 0xF000F0, OverlayTexture.f_118083_, poseStack, (MultiBufferSource)immediateSource, (Level)minecraft.f_91073_, 0);
        immediateSource.m_109911_();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        poseStack.m_85849_();
    }

    private static void renderItemIconNoStateChange(PoseStack poseStack, MultiBufferSource bufferSource, ItemStack itemStack, float x, float y, float alpha) {
        Minecraft minecraft = Minecraft.m_91087_();
        ItemRenderer itemRenderer = minecraft.m_91291_();
        poseStack.m_85836_();
        poseStack.m_252880_(x + 8.0f, y + 8.0f, -0.01f);
        float iconScale = 14.0f;
        poseStack.m_85841_(iconScale, -iconScale, 0.001f);
        poseStack.m_85850_().m_252943_().identity();
        MultiBufferSource.BufferSource immediateSource = minecraft.m_91269_().m_110104_();
        itemRenderer.m_269128_(itemStack, ItemDisplayContext.GUI, 0xF000F0, OverlayTexture.f_118083_, poseStack, (MultiBufferSource)immediateSource, (Level)minecraft.f_91073_, 0);
        immediateSource.m_109911_();
        poseStack.m_85849_();
    }

    private static Vec3 getInterpolatedPosition(ItemEntity entity, float partialTick) {
        double x = entity.f_19854_ + (entity.m_20185_() - entity.f_19854_) * (double)partialTick;
        double y = entity.f_19855_ + (entity.m_20186_() - entity.f_19855_) * (double)partialTick;
        double z = entity.f_19856_ + (entity.m_20189_() - entity.f_19856_) * (double)partialTick;
        return new Vec3(x, y, z);
    }

    private static float calculateDistanceScale(double distance) {
        if (distance <= 3.0) {
            return 1.0f;
        }
        float maxDist = (float)InsightConfig.getMaxRenderDistance();
        float t = (float)(distance - 3.0) / (maxDist - 3.0f);
        t = Math.min(1.0f, Math.max(0.0f, t));
        return 1.0f + t * 0.5f;
    }

    public static void clearAnimations() {
        animationHelper.clear();
    }

    private record ItemWithDistance(ItemEntity entity, double distance, Vec3 position) {
    }
}

