/*
 * Decompiled with CFR 0.152.
 */
package com.chan1.client.feature.misc;

import com.chan1.client.config.InsightConfig;
import com.chan1.client.util.detection.CrosshairDetector;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public final class BedBlockDetector {
    public static BlockPos getTargetedBedPos() {
        CrosshairDetector.BlockTarget<BedBlock> target = CrosshairDetector.getTargetedBlockInfo(BedBlock.class);
        if (target == null) {
            return null;
        }
        return BedBlockDetector.getBedHeadPos(target.pos(), target.state());
    }

    private static BlockPos getBedHeadPos(BlockPos pos, BlockState state) {
        if (state.m_61143_((Property)BedBlock.f_49440_) == BedPart.HEAD) {
            return pos;
        }
        return pos.m_121945_(BedBlock.m_49557_((BlockState)state));
    }

    public static Vec3 getBedBillboardPosition(BlockPos bedHeadPos) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null) {
            return Vec3.m_82512_((Vec3i)bedHeadPos).m_82520_(0.0, 1.0, 0.0);
        }
        BlockState state = minecraft.f_91073_.m_8055_(bedHeadPos);
        if (!(state.m_60734_() instanceof BedBlock)) {
            return Vec3.m_82512_((Vec3i)bedHeadPos).m_82520_(0.0, 1.0, 0.0);
        }
        BlockPos footPos = bedHeadPos.m_121945_(BedBlock.m_49557_((BlockState)state));
        double centerX = (double)(bedHeadPos.m_123341_() + footPos.m_123341_()) / 2.0 + 0.5;
        double centerZ = (double)(bedHeadPos.m_123343_() + footPos.m_123343_()) / 2.0 + 0.5;
        double centerY = (double)bedHeadPos.m_123342_() + 0.5 + InsightConfig.getTooltipYOffset();
        return new Vec3(centerX, centerY, centerZ);
    }
}

