/*
 * Decompiled with CFR 0.152.
 */
package com.chan1.client.feature.misc;

import com.chan1.client.config.InsightConfig;
import com.chan1.client.feature.misc.BedBlockDetector;
import com.chan1.client.util.MinecraftTimeHelper;
import com.chan1.client.util.render.TooltipBackgroundRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public final class BedTimerRenderer {
    private static final int LIGHT_FULL_BRIGHT = 0xF000F0;
    private static final float MIN_READABLE_SCALE = 0.65f;
    private static final float OPTIMAL_SCALE = 0.85f;
    private static final int ZZZ_COLOR = -6710785;

    public static void renderBillboards(PoseStack poseStack, MultiBufferSource bufferSource, Camera camera, float partialTick) {
        boolean isNight;
        if (!InsightConfig.isBedTimerEnabled()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null || minecraft.f_91073_ == null || minecraft.f_91080_ != null) {
            return;
        }
        BlockPos bedPos = BedBlockDetector.getTargetedBedPos();
        if (bedPos == null) {
            return;
        }
        Vec3 billboardPos = BedBlockDetector.getBedBillboardPosition(bedPos);
        Vec3 cameraPos = camera.m_90583_();
        Vec3 toBed = billboardPos.m_82546_(cameraPos);
        double distance = toBed.m_82553_();
        Vec3 cameraLookVec = new Vec3(camera.m_253058_());
        if (toBed.m_82541_().m_82526_(cameraLookVec) < -0.2) {
            return;
        }
        if (distance > InsightConfig.getMaxRenderDistance()) {
            return;
        }
        if (bufferSource instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource source = (MultiBufferSource.BufferSource)bufferSource;
            source.m_109911_();
        }
        if (isNight = MinecraftTimeHelper.isNightTime(minecraft.f_91073_)) {
            BedTimerRenderer.renderNightZzz(poseStack, billboardPos, distance, cameraPos, camera, minecraft.f_91062_);
        } else {
            String timeText = MinecraftTimeHelper.formatTimeUntilNight(minecraft.f_91073_);
            if (timeText != null) {
                BedTimerRenderer.renderDayTooltip(poseStack, billboardPos, distance, cameraPos, camera, minecraft.f_91062_, timeText);
            }
        }
    }

    private static void renderDayTooltip(PoseStack poseStack, Vec3 billboardPos, double distance, Vec3 cameraPos, Camera camera, Font font, String timeText) {
        Minecraft minecraft = Minecraft.m_91087_();
        int textWidth = font.m_92895_(timeText);
        int tooltipWidth = textWidth + 12;
        int tooltipHeight = 16;
        poseStack.m_85836_();
        poseStack.m_85837_(billboardPos.f_82479_ - cameraPos.f_82479_, billboardPos.f_82480_ - cameraPos.f_82480_, billboardPos.f_82481_ - cameraPos.f_82481_);
        Quaternionf cameraRotation = camera.m_253121_();
        poseStack.m_252781_(cameraRotation);
        float baseScale = InsightConfig.getBillboardScale();
        float distanceScale = BedTimerRenderer.calculateDistanceScale(distance);
        float scale = baseScale * distanceScale;
        poseStack.m_85841_(-scale, -scale, scale);
        float halfWidth = (float)tooltipWidth / 2.0f;
        float halfHeight = (float)tooltipHeight / 2.0f;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float left = -halfWidth - 3.0f;
        float top = -halfHeight - 3.0f;
        float right = halfWidth + 3.0f;
        float bottom = halfHeight + 3.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        TooltipBackgroundRenderer.renderNoStateChange(matrix, left, top, right, bottom, 1.0f);
        MultiBufferSource.BufferSource immediateSource = minecraft.m_91269_().m_110104_();
        float textX = (float)(-textWidth) / 2.0f;
        Objects.requireNonNull(font);
        float textY = (float)(-9) / 2.0f;
        font.m_271703_(timeText, textX, textY, -1, false, matrix, (MultiBufferSource)immediateSource, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        immediateSource.m_109911_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    private static void renderNightZzz(PoseStack poseStack, Vec3 billboardPos, double distance, Vec3 cameraPos, Camera camera, Font font) {
        Minecraft minecraft = Minecraft.m_91087_();
        long gameTime = minecraft.f_91073_ != null ? minecraft.f_91073_.m_46467_() : 0L;
        float time = (float)(gameTime % 40L) / 40.0f * (float)Math.PI * 2.0f;
        int zWidth = font.m_92895_("z");
        float charSpacing = zWidth + 2;
        float totalWidth = charSpacing * 3.0f - 2.0f;
        poseStack.m_85836_();
        float floatOffset = (float)Math.sin(time * 0.5f) * 3.0f;
        poseStack.m_85837_(billboardPos.f_82479_ - cameraPos.f_82479_, billboardPos.f_82480_ - cameraPos.f_82480_, billboardPos.f_82481_ - cameraPos.f_82481_);
        Quaternionf cameraRotation = camera.m_253121_();
        poseStack.m_252781_(cameraRotation);
        float baseScale = InsightConfig.getBillboardScale();
        float distanceScale = BedTimerRenderer.calculateDistanceScale(distance);
        float scale = baseScale * distanceScale;
        float pulseScale = 1.0f + (float)Math.sin(time * 0.7f) * 0.05f;
        poseStack.m_85841_(-(scale *= pulseScale), -scale, scale);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        MultiBufferSource.BufferSource immediateSource = minecraft.m_91269_().m_110104_();
        float startX = -totalWidth / 2.0f;
        for (int i = 0; i < 3; ++i) {
            float phaseOffset = (float)i * 0.8f;
            float waveY = (float)Math.sin(time + phaseOffset) * 4.0f;
            float sizeMultiplier = 1.0f + (float)i * 0.15f;
            int alpha = 255 - i * 25;
            int color = alpha << 24 | 0x9999FF;
            poseStack.m_85836_();
            float charX = startX + (float)i * charSpacing;
            Objects.requireNonNull(font);
            float charY = (float)(-9) / 2.0f + waveY + floatOffset;
            if (sizeMultiplier != 1.0f) {
                float f = charX + (float)zWidth / 2.0f;
                Objects.requireNonNull(font);
                poseStack.m_252880_(f, charY + 9.0f / 2.0f, 0.0f);
                poseStack.m_85841_(sizeMultiplier, sizeMultiplier, 1.0f);
                float f2 = -(charX + (float)zWidth / 2.0f);
                Objects.requireNonNull(font);
                poseStack.m_252880_(f2, -(charY + 9.0f / 2.0f), 0.0f);
            }
            Matrix4f matrix = poseStack.m_85850_().m_252922_();
            font.m_271703_("z", charX, charY, color, false, matrix, (MultiBufferSource)immediateSource, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
            poseStack.m_85849_();
        }
        immediateSource.m_109911_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    private static float calculateDistanceScale(double distance) {
        float maxDist = (float)InsightConfig.getMaxRenderDistance();
        if (distance <= 1.5) {
            float t = (float)(distance / 1.5);
            return 0.65f + t * 0.20000005f * 0.5f;
        }
        if (distance <= 4.0) {
            float t = (float)((distance - 1.5) / 2.5);
            float startScale = 0.75f;
            return startScale + t * (0.85f - startScale);
        }
        float t = (float)((distance - 4.0) / ((double)maxDist - 4.0));
        t = Math.min(1.0f, Math.max(0.0f, t));
        return 0.85f + t * 0.25f;
    }
}

