/*
 * Decompiled with CFR 0.152.
 */
package com.chan1.client.feature.misc;

import com.chan1.client.config.InsightConfig;
import com.chan1.client.util.detection.CrosshairDetector;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public final class CropGrowthDetector {
    public static CropInfo getTargetedCropInfo() {
        BlockHitResult blockHit = CrosshairDetector.getTargetedBlockHit();
        if (blockHit == null || blockHit.m_6662_() != HitResult.Type.BLOCK) {
            return null;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null) {
            return null;
        }
        BlockPos pos = blockHit.m_82425_();
        BlockState state = minecraft.f_91073_.m_8055_(pos);
        return CropGrowthDetector.getCropInfo(pos, state);
    }

    private static CropInfo getCropInfo(BlockPos pos, BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            int age = crop.m_52305_(state);
            int maxAge = crop.m_7419_();
            String name = CropGrowthDetector.getCropName(block);
            return new CropInfo(pos, name, age, maxAge, age >= maxAge);
        }
        if (block instanceof BeetrootBlock) {
            int maxAge;
            int age;
            return new CropInfo(pos, "Beetroot", age, maxAge, (age = ((Integer)state.m_61143_((Property)BeetrootBlock.f_49657_)).intValue()) >= (maxAge = 3));
        }
        if (block instanceof NetherWartBlock) {
            int maxAge;
            int age;
            return new CropInfo(pos, "Nether Wart", age, maxAge, (age = ((Integer)state.m_61143_((Property)NetherWartBlock.f_54967_)).intValue()) >= (maxAge = 3));
        }
        if (block instanceof StemBlock) {
            int age = (Integer)state.m_61143_((Property)StemBlock.f_57013_);
            int maxAge = 7;
            String name = block.m_49954_().getString();
            return new CropInfo(pos, name, age, maxAge, age >= maxAge);
        }
        if (block instanceof SweetBerryBushBlock) {
            int maxAge;
            int age;
            return new CropInfo(pos, "Sweet Berries", age, maxAge, (age = ((Integer)state.m_61143_((Property)SweetBerryBushBlock.f_57244_)).intValue()) >= (maxAge = 3));
        }
        if (block instanceof CocoaBlock) {
            int maxAge;
            int age;
            return new CropInfo(pos, "Cocoa", age, maxAge, (age = ((Integer)state.m_61143_((Property)CocoaBlock.f_51736_)).intValue()) >= (maxAge = 2));
        }
        return null;
    }

    private static String getCropName(Block block) {
        String name = block.m_49954_().getString();
        if (name.toLowerCase().contains("wheat")) {
            return "Wheat";
        }
        if (name.toLowerCase().contains("carrot")) {
            return "Carrots";
        }
        if (name.toLowerCase().contains("potato")) {
            return "Potatoes";
        }
        return name;
    }

    public static Vec3 getCropBillboardPosition(BlockPos cropPos) {
        return Vec3.m_82512_((Vec3i)cropPos).m_82520_(0.0, 0.1 + InsightConfig.getTooltipYOffset(), 0.0);
    }

    public record CropInfo(BlockPos pos, String cropName, int currentAge, int maxAge, boolean isFullyGrown) {
        public float getGrowthPercent() {
            if (this.maxAge == 0) {
                return 100.0f;
            }
            return (float)this.currentAge / (float)this.maxAge * 100.0f;
        }
    }
}

