/*
 * Decompiled with CFR 0.152.
 */
package com.chan1.client.feature.misc;

import com.chan1.client.config.InsightConfig;
import com.chan1.client.feature.misc.CropGrowthDetector;
import com.chan1.client.util.render.TooltipBackgroundRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public final class CropGrowthRenderer {
    private static final int LIGHT_FULL_BRIGHT = 0xF000F0;
    private static final float MIN_READABLE_SCALE = 0.65f;
    private static final float OPTIMAL_SCALE = 0.85f;
    private static final int TEXT_COLOR = -1;
    private static final int FULLY_GROWN_COLOR = -11141291;

    public static void renderBillboards(PoseStack poseStack, MultiBufferSource bufferSource, Camera camera, float partialTick) {
        if (!InsightConfig.isCropGrowthEnabled()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null || minecraft.f_91073_ == null || minecraft.f_91080_ != null) {
            return;
        }
        CropGrowthDetector.CropInfo cropInfo = CropGrowthDetector.getTargetedCropInfo();
        if (cropInfo == null) {
            return;
        }
        Vec3 billboardPos = CropGrowthDetector.getCropBillboardPosition(cropInfo.pos());
        Vec3 cameraPos = camera.m_90583_();
        Vec3 toCrop = billboardPos.m_82546_(cameraPos);
        double distance = toCrop.m_82553_();
        Vec3 cameraLookVec = new Vec3(camera.m_253058_());
        if (toCrop.m_82541_().m_82526_(cameraLookVec) < -0.2) {
            return;
        }
        if (distance > InsightConfig.getMaxRenderDistance()) {
            return;
        }
        if (bufferSource instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource source = (MultiBufferSource.BufferSource)bufferSource;
            source.m_109911_();
        }
        CropGrowthRenderer.renderCropTooltip(poseStack, billboardPos, distance, cameraPos, camera, minecraft.f_91062_, cropInfo);
    }

    private static void renderCropTooltip(PoseStack poseStack, Vec3 billboardPos, double distance, Vec3 cameraPos, Camera camera, Font font, CropGrowthDetector.CropInfo cropInfo) {
        int textColor;
        String statusText;
        Minecraft minecraft = Minecraft.m_91087_();
        if (cropInfo.isFullyGrown()) {
            statusText = cropInfo.cropName() + " - Ready!";
            textColor = -11141291;
        } else {
            int percent = (int)cropInfo.getGrowthPercent();
            statusText = cropInfo.cropName() + " - " + percent + "%";
            textColor = -1;
        }
        int textWidth = font.m_92895_(statusText);
        float progressBarWidth = Math.max(textWidth, 40);
        float progressBarHeight = 4.0f;
        float tooltipWidth = Math.max((float)textWidth, progressBarWidth) + 12.0f;
        Objects.requireNonNull(font);
        float tooltipHeight = 9.0f + progressBarHeight + 10.0f;
        poseStack.m_85836_();
        poseStack.m_85837_(billboardPos.f_82479_ - cameraPos.f_82479_, billboardPos.f_82480_ - cameraPos.f_82480_, billboardPos.f_82481_ - cameraPos.f_82481_);
        Quaternionf cameraRotation = camera.m_253121_();
        poseStack.m_252781_(cameraRotation);
        float baseScale = InsightConfig.getBillboardScale();
        float distanceScale = CropGrowthRenderer.calculateDistanceScale(distance);
        float scale = baseScale * distanceScale;
        poseStack.m_85841_(-scale, -scale, scale);
        float halfWidth = tooltipWidth / 2.0f;
        float halfHeight = tooltipHeight / 2.0f;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float left = -halfWidth - 3.0f;
        float top = -halfHeight - 3.0f;
        float right = halfWidth + 3.0f;
        float bottom = halfHeight + 3.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        TooltipBackgroundRenderer.renderNoStateChange(matrix, left, top, right, bottom, 1.0f);
        MultiBufferSource.BufferSource immediateSource = minecraft.m_91269_().m_110104_();
        float textX = (float)(-textWidth) / 2.0f;
        float textY = -halfHeight + 4.0f;
        font.m_271703_(statusText, textX, textY, textColor, false, matrix, (MultiBufferSource)immediateSource, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        immediateSource.m_109911_();
        if (!cropInfo.isFullyGrown()) {
            float barX = -progressBarWidth / 2.0f;
            Objects.requireNonNull(font);
            float barY = textY + 9.0f + 3.0f;
            float progress = cropInfo.getGrowthPercent() / 100.0f;
            CropGrowthRenderer.renderProgressBar(matrix, barX, barY, progressBarWidth, progressBarHeight, progress);
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    private static void renderProgressBar(Matrix4f matrix, float x, float y, float width, float height, float progress) {
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        float bgR = 0.2f;
        float bgG = 0.2f;
        float bgB = 0.2f;
        float bgA = 1.0f;
        builder.m_252986_(matrix, x, y + height, 0.0f).m_85950_(bgR, bgG, bgB, bgA).m_5752_();
        builder.m_252986_(matrix, x + width, y + height, 0.0f).m_85950_(bgR, bgG, bgB, bgA).m_5752_();
        builder.m_252986_(matrix, x + width, y, 0.0f).m_85950_(bgR, bgG, bgB, bgA).m_5752_();
        builder.m_252986_(matrix, x, y, 0.0f).m_85950_(bgR, bgG, bgB, bgA).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
        if (progress > 0.0f) {
            float fillWidth = width * Math.min(1.0f, progress);
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            float fillR = 0.27f;
            float fillG = 0.67f;
            float fillB = 0.27f;
            float fillA = 1.0f;
            builder.m_252986_(matrix, x, y + height, 0.0f).m_85950_(fillR, fillG, fillB, fillA).m_5752_();
            builder.m_252986_(matrix, x + fillWidth, y + height, 0.0f).m_85950_(fillR, fillG, fillB, fillA).m_5752_();
            builder.m_252986_(matrix, x + fillWidth, y, 0.0f).m_85950_(fillR, fillG, fillB, fillA).m_5752_();
            builder.m_252986_(matrix, x, y, 0.0f).m_85950_(fillR, fillG, fillB, fillA).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
        }
    }

    private static float calculateDistanceScale(double distance) {
        float maxDist = (float)InsightConfig.getMaxRenderDistance();
        if (distance <= 1.5) {
            float t = (float)(distance / 1.5);
            return 0.65f + t * 0.20000005f * 0.5f;
        }
        if (distance <= 4.0) {
            float t = (float)((distance - 1.5) / 2.5);
            float startScale = 0.75f;
            return startScale + t * (0.85f - startScale);
        }
        float t = (float)((distance - 4.0) / ((double)maxDist - 4.0));
        t = Math.min(1.0f, Math.max(0.0f, t));
        return 0.85f + t * 0.25f;
    }
}

