/*
 * Decompiled with CFR 0.152.
 */
package com.chan1.client.feature.targethud;

import com.chan1.client.config.InsightConfig;
import com.chan1.client.feature.targethud.TargetEntityDetector;
import com.chan1.client.feature.targethud.TargetHudPositioner;
import com.chan1.client.util.render.AnimationHelper;
import com.chan1.client.util.render.TooltipBackgroundRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashSet;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public final class TargetHudBillboardRenderer {
    private static final int LIGHT_FULL_BRIGHT = 0xF000F0;
    private static final float MIN_READABLE_SCALE = 0.65f;
    private static final float OPTIMAL_SCALE = 0.85f;
    private static final int HEALTH_BAR_BG_COLOR = -15066598;
    private static final int HEALTH_BAR_BORDER_COLOR = -16777216;
    private static final int HEALTH_COLOR_FULL = -11141291;
    private static final int HEALTH_COLOR_HALF = -171;
    private static final int HEALTH_COLOR_LOW = -43691;
    private static final AnimationHelper animationHelper = new AnimationHelper();

    private TargetHudBillboardRenderer() {
    }

    public static void renderBillboards(PoseStack poseStack, MultiBufferSource bufferSource, Camera camera, float partialTick) {
        if (!InsightConfig.isTargetHudEnabled()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null || minecraft.f_91073_ == null || minecraft.f_91080_ != null) {
            return;
        }
        LivingEntity target = TargetEntityDetector.getHoveredEntity();
        HashSet<Integer> currentEntityIds = new HashSet<Integer>();
        if (target != null) {
            currentEntityIds.add(target.m_19879_());
        } else {
            TargetHudPositioner.clear();
        }
        animationHelper.cleanupStaleAnimations(currentEntityIds);
        if (target == null) {
            return;
        }
        Vec3 cameraPos = camera.m_90583_();
        Vec3 entityPos = TargetHudBillboardRenderer.getInterpolatedPosition(target, partialTick);
        Vec3 toEntity = entityPos.m_82546_(cameraPos);
        double distance = toEntity.m_82553_();
        Vec3 cameraLookVec = new Vec3(camera.m_253058_());
        if (toEntity.m_82541_().m_82526_(cameraLookVec) < -0.2) {
            return;
        }
        if (distance > InsightConfig.getMaxRenderDistance()) {
            return;
        }
        if (bufferSource instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource source = (MultiBufferSource.BufferSource)bufferSource;
            source.m_109911_();
        }
        float animScale = 1.0f;
        if (InsightConfig.isAnimationsEnabled()) {
            animationHelper.getOrCreateAppearAnimation(target.m_19879_());
            AnimationHelper.AnimationState state = animationHelper.getAnimationState(target.m_19879_());
            if (state != null) {
                animScale = AnimationHelper.calculateScale(state, InsightConfig.getAnimationDurationMs());
            }
        }
        if (animScale > 0.001f) {
            TargetHudBillboardRenderer.renderTargetHud(poseStack, bufferSource, target, entityPos, distance, cameraPos, camera, minecraft.f_91062_, animScale);
        }
    }

    private static void renderTargetHud(PoseStack poseStack, MultiBufferSource bufferSource, LivingEntity entity, Vec3 entityPos, double distance, Vec3 cameraPos, Camera camera, Font font, float animScale) {
        Minecraft minecraft = Minecraft.m_91087_();
        float alpha = 1.0f;
        Component entityName = entity.m_5446_();
        float health = entity.m_21223_();
        float maxHealth = entity.m_21233_();
        float healthPercent = Math.min(1.0f, health / maxHealth);
        String healthText = String.format("%.1f / %.1f", Float.valueOf(health), Float.valueOf(maxHealth));
        int nameWidth = font.m_92852_((FormattedText)entityName);
        int healthTextWidth = font.m_92895_(healthText);
        int healthBarWidth = Math.max(nameWidth, healthTextWidth) + 10;
        healthBarWidth = Math.max(healthBarWidth, 60);
        int tooltipWidth = healthBarWidth + 12;
        int healthBarHeight = 6;
        int tooltipHeight = 12 + healthBarHeight + 2 + 10 + 4;
        Vec3 billboardPos = TargetHudPositioner.calculateBillboardPosition(entity, entityPos, camera, InsightConfig.getTooltipYOffset(), InsightConfig.isTargetHudSmartPositioning());
        poseStack.m_85836_();
        poseStack.m_85837_(billboardPos.f_82479_ - cameraPos.f_82479_, billboardPos.f_82480_ - cameraPos.f_82480_, billboardPos.f_82481_ - cameraPos.f_82481_);
        Quaternionf cameraRotation = camera.m_253121_();
        poseStack.m_252781_(cameraRotation);
        float baseScale = InsightConfig.getBillboardScale();
        float distanceScale = TargetHudBillboardRenderer.calculateDistanceScale(distance);
        float scale = baseScale * distanceScale * animScale;
        poseStack.m_85841_(-scale, -scale, scale);
        float halfWidth = (float)tooltipWidth / 2.0f;
        float halfHeight = (float)tooltipHeight / 2.0f;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float left = -halfWidth - 3.0f;
        float top = -halfHeight - 3.0f;
        float right = halfWidth + 3.0f;
        float bottom = halfHeight + 3.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        TooltipBackgroundRenderer.renderNoStateChange(matrix, left, top, right, bottom, alpha);
        MultiBufferSource.BufferSource immediateSource = minecraft.m_91269_().m_110104_();
        int textAlpha = (int)(255.0f * alpha);
        float nameX = (float)(-nameWidth) / 2.0f;
        float nameY = -halfHeight + 4.0f;
        font.m_272077_(entityName, nameX, nameY, textAlpha << 24 | 0xFFFFFF, false, matrix, (MultiBufferSource)immediateSource, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        immediateSource.m_109911_();
        float barLeft = (float)(-healthBarWidth) / 2.0f;
        float barTop = nameY + 12.0f;
        float barRight = (float)healthBarWidth / 2.0f;
        float barBottom = barTop + (float)healthBarHeight;
        TargetHudBillboardRenderer.renderHealthBar(matrix, barLeft, barTop, barRight, barBottom, healthPercent, alpha);
        immediateSource = minecraft.m_91269_().m_110104_();
        float healthTextX = (float)(-healthTextWidth) / 2.0f;
        float healthTextY = barBottom + 3.0f;
        int healthColor = TargetHudBillboardRenderer.getHealthColor(healthPercent);
        font.m_271703_(healthText, healthTextX, healthTextY, textAlpha << 24 | healthColor & 0xFFFFFF, false, matrix, (MultiBufferSource)immediateSource, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        immediateSource.m_109911_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    private static void renderHealthBar(Matrix4f matrix, float left, float top, float right, float bottom, float healthPercent, float alpha) {
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        float z = 0.0f;
        TargetHudBillboardRenderer.addQuad(buffer, matrix, left - 1.0f, top - 1.0f, right + 1.0f, top, z, -16777216, alpha);
        TargetHudBillboardRenderer.addQuad(buffer, matrix, left - 1.0f, bottom, right + 1.0f, bottom + 1.0f, z, -16777216, alpha);
        TargetHudBillboardRenderer.addQuad(buffer, matrix, left - 1.0f, top, left, bottom, z, -16777216, alpha);
        TargetHudBillboardRenderer.addQuad(buffer, matrix, right, top, right + 1.0f, bottom, z, -16777216, alpha);
        TargetHudBillboardRenderer.addQuad(buffer, matrix, left, top, right, bottom, z, -15066598, alpha);
        float fillWidth = (right - left) * healthPercent;
        int healthColor = TargetHudBillboardRenderer.getHealthColor(healthPercent);
        TargetHudBillboardRenderer.addQuad(buffer, matrix, left, top, left + fillWidth, bottom, z, healthColor, alpha);
        tesselator.m_85914_();
    }

    private static void addQuad(BufferBuilder buffer, Matrix4f matrix, float x1, float y1, float x2, float y2, float z, int color, float alpha) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f * alpha;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        buffer.m_252986_(matrix, x1, y1, z).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, x1, y2, z).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, x2, y1, z).m_85950_(r, g, b, a).m_5752_();
    }

    private static int getHealthColor(float healthPercent) {
        if (healthPercent > 0.5f) {
            float t = (healthPercent - 0.5f) * 2.0f;
            return TargetHudBillboardRenderer.interpolateColor(-171, -11141291, t);
        }
        float t = healthPercent * 2.0f;
        return TargetHudBillboardRenderer.interpolateColor(-43691, -171, t);
    }

    private static int interpolateColor(int color1, int color2, float t) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * t);
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static Vec3 getInterpolatedPosition(LivingEntity entity, float partialTick) {
        double x = entity.f_19854_ + (entity.m_20185_() - entity.f_19854_) * (double)partialTick;
        double y = entity.f_19855_ + (entity.m_20186_() - entity.f_19855_) * (double)partialTick;
        double z = entity.f_19856_ + (entity.m_20189_() - entity.f_19856_) * (double)partialTick;
        return new Vec3(x, y, z);
    }

    private static float calculateDistanceScale(double distance) {
        float maxDist = (float)InsightConfig.getMaxRenderDistance();
        if (distance <= 1.5) {
            float t = (float)(distance / 1.5);
            return 0.65f + t * 0.20000005f * 0.5f;
        }
        if (distance <= 4.0) {
            float t = (float)((distance - 1.5) / 2.5);
            float startScale = 0.75f;
            return startScale + t * (0.85f - startScale);
        }
        float t = (float)((distance - 4.0) / ((double)maxDist - 4.0));
        t = Math.min(1.0f, Math.max(0.0f, t));
        return 0.85f + t * 0.25f;
    }

    public static void clearAnimations() {
        animationHelper.clear();
        TargetHudPositioner.clear();
    }
}

