/*
 * Decompiled with CFR 0.152.
 */
package com.chan1.client.feature.targethud;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public final class TargetHudPositioner {
    private static final float POSITION_LERP_SPEED = 0.035f;
    private static final double HUD_OFFSET_DISTANCE = 0.85;
    private static final Map<Integer, Vec3> currentPositions = new HashMap<Integer, Vec3>();

    private TargetHudPositioner() {
    }

    public static Vec3 calculateBillboardPosition(LivingEntity entity, Vec3 entityPos, Camera camera, double yOffset, boolean smartEnabled) {
        float height = entity.m_20206_();
        Vec3 fallback = entityPos.m_82520_(0.0, (double)height + yOffset, 0.0);
        if (!smartEnabled) {
            return fallback;
        }
        int entityId = entity.m_19879_();
        Vec3 targetPosition = TargetHudPositioner.calculateOptimalPosition(entity, entityPos, camera, yOffset);
        Vec3 currentPosition = currentPositions.get(entityId);
        if (currentPosition == null) {
            currentPosition = targetPosition;
        }
        Vec3 newPosition = TargetHudPositioner.lerpVec3(currentPosition, targetPosition, 0.035f);
        currentPositions.put(entityId, newPosition);
        return newPosition;
    }

    private static Vec3 calculateOptimalPosition(LivingEntity entity, Vec3 entityPos, Camera camera, double yOffset) {
        double minOffset;
        double currentHorizOffset;
        double baseY;
        double baseZ;
        double baseX;
        Vec3 cameraPos = camera.m_90583_();
        float height = entity.m_20206_();
        float halfWidth = entity.m_20205_() / 2.0f;
        Vec3 entityCenter = entityPos.m_82520_(0.0, (double)height * 0.5, 0.0);
        double entityTopY = entityPos.f_82480_ + (double)height + yOffset;
        Vec3 lookDir = new Vec3(camera.m_253058_());
        Vec3 upDir = new Vec3(camera.m_253028_());
        Vec3 rightDir = lookDir.m_82537_(upDir).m_82541_();
        Vec3 toEntity = entityCenter.m_82546_(cameraPos);
        double dist = toEntity.m_82553_();
        if (dist < 0.1) {
            return entityPos.m_82520_(0.0, (double)height + yOffset, 0.0);
        }
        Vec3 toCamera = toEntity.m_82541_().m_82490_(-1.0);
        Vec3 crosshairPoint = cameraPos.m_82549_(lookDir.m_82490_(dist));
        Vec3 entityToCrosshair = crosshairPoint.m_82546_(entityCenter);
        double crosshairDist = entityToCrosshair.m_82553_();
        double cameraPitch = Math.toRadians(camera.m_90589_());
        double topAboveCamera = entityTopY - cameraPos.f_82480_;
        double deadZone = (double)halfWidth + 1.2;
        boolean crosshairOnEntity = crosshairDist < deadZone;
        boolean lookingDownAtEntity = cameraPos.f_82480_ > entityCenter.f_82480_ && cameraPitch > 0.25;
        double topPositionBadness = 0.0;
        if (topAboveCamera > 0.4) {
            topPositionBadness = Math.min(1.0, (topAboveCamera - 0.4) / 2.0);
        }
        if ((double)height > 1.8) {
            topPositionBadness = Math.max(topPositionBadness, Math.min(1.0, ((double)height - 1.8) / 1.8));
        }
        if (cameraPitch > 0.2) {
            double downBadness = Math.min(1.0, (cameraPitch - 0.2) / 0.6);
            topPositionBadness = Math.max(topPositionBadness, downBadness * 0.6);
        }
        double offsetDist = 0.85 + (double)halfWidth + 0.25;
        if (crosshairOnEntity || lookingDownAtEntity && cameraPitch > 0.4) {
            double sideDir = 1.0;
            double dotRight = entityToCrosshair.f_82479_ * rightDir.f_82479_ + entityToCrosshair.f_82481_ * rightDir.f_82481_;
            if (Math.abs(dotRight) > 0.3) {
                sideDir = Math.signum(dotRight);
            }
            double sideStrength = 0.7;
            if (lookingDownAtEntity && cameraPitch > 0.4) {
                sideStrength = 0.75 + 0.15 * Math.min(1.0, (cameraPitch - 0.4) / 0.4);
            }
            baseX = rightDir.f_82479_ * sideDir * offsetDist * sideStrength;
            baseZ = rightDir.f_82481_ * sideDir * offsetDist * sideStrength;
            double blend = TargetHudPositioner.easeOutCubic(topPositionBadness);
            double topY = (double)height + yOffset;
            double sideY = (double)height * 0.5;
            baseY = topY + (sideY - topY) * Math.max(blend, lookingDownAtEntity ? 0.4 : 0.0);
        } else {
            Vec3 towardsCrosshair = entityToCrosshair.m_82541_();
            double horizShiftX = towardsCrosshair.f_82479_;
            double horizShiftZ = towardsCrosshair.f_82481_;
            double horizLen = Math.sqrt(horizShiftX * horizShiftX + horizShiftZ * horizShiftZ);
            if (horizLen > 0.01) {
                horizShiftX /= horizLen;
                horizShiftZ /= horizLen;
            } else {
                horizShiftX = rightDir.f_82479_;
                horizShiftZ = rightDir.f_82481_;
            }
            double effectiveOffset = Math.max(0.0, crosshairDist - deadZone);
            double horizStrength = Math.min(1.0, effectiveOffset / 3.5);
            horizStrength = TargetHudPositioner.easeOutQuad(horizStrength) * 0.6;
            baseX = horizShiftX * offsetDist * (0.5 + 0.3 * horizStrength);
            baseZ = horizShiftZ * offsetDist * (0.5 + 0.3 * horizStrength);
            double blend = TargetHudPositioner.easeOutCubic(topPositionBadness);
            double topY = (double)height + yOffset;
            double sideY = (double)height * 0.55;
            baseY = topY + (sideY - topY) * blend;
        }
        double camerawardBias = 0.15;
        baseX += toCamera.f_82479_ * camerawardBias;
        baseZ += toCamera.f_82481_ * camerawardBias;
        if (dist < 2.0) {
            double closeFactor = Math.min(1.0, (2.0 - dist) / 1.5);
            closeFactor = TargetHudPositioner.easeOutQuad(closeFactor);
            baseX *= 1.0 + 0.25 * closeFactor;
            baseZ *= 1.0 + 0.25 * closeFactor;
        }
        if ((currentHorizOffset = Math.sqrt(baseX * baseX + baseZ * baseZ)) < (minOffset = (double)halfWidth + 0.4) && currentHorizOffset > 0.01) {
            double scale = minOffset / currentHorizOffset;
            baseX *= scale;
            baseZ *= scale;
        }
        return entityPos.m_82520_(baseX, baseY, baseZ);
    }

    private static double easeOutQuad(double t) {
        return 1.0 - (1.0 - t) * (1.0 - t);
    }

    private static double easeOutCubic(double t) {
        return 1.0 - Math.pow(1.0 - t, 3.0);
    }

    private static Vec3 lerpVec3(Vec3 from, Vec3 to, float t) {
        return new Vec3(from.f_82479_ + (to.f_82479_ - from.f_82479_) * (double)t, from.f_82480_ + (to.f_82480_ - from.f_82480_) * (double)t, from.f_82481_ + (to.f_82481_ - from.f_82481_) * (double)t);
    }

    public static void clear() {
        currentPositions.clear();
    }
}

