/*
 * Decompiled with CFR 0.152.
 */
package com.chan1.client.util.detection;

import com.chan1.client.config.InsightConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public final class CrosshairDetector {
    private static long lastCacheFrame = -1L;
    private static HitResult cachedVanillaHit = null;
    private static BlockHitResult cachedBlockTarget = null;
    private static boolean blockSearchDone = false;
    private static Vec3 cachedEyePos = null;
    private static Vec3 cachedLookVec = null;
    private static double cachedRange = 0.0;

    private CrosshairDetector() {
    }

    public static <T extends Entity> T getTargetedEntity(Class<T> entityClass) {
        Entity entity;
        CrosshairDetector.refreshCacheIfNeeded();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return null;
        }
        if (cachedVanillaHit != null && cachedVanillaHit.m_6662_() == HitResult.Type.ENTITY && entityClass.isInstance(entity = ((EntityHitResult)cachedVanillaHit).m_82443_())) {
            return (T)entity;
        }
        return CrosshairDetector.findEntityManual(mc, entityClass, null);
    }

    public static <T extends Entity> T getTargetedEntity(Class<T> entityClass, Predicate<T> validator) {
        Entity typed;
        Entity entity;
        CrosshairDetector.refreshCacheIfNeeded();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return null;
        }
        if (cachedVanillaHit != null && cachedVanillaHit.m_6662_() == HitResult.Type.ENTITY && entityClass.isInstance(entity = ((EntityHitResult)cachedVanillaHit).m_82443_()) && validator.test(typed = entity)) {
            return (T)typed;
        }
        return CrosshairDetector.findEntityManual(mc, entityClass, validator);
    }

    public static BlockHitResult getTargetedBlockHit() {
        BlockHitResult blockHit;
        double distance;
        CrosshairDetector.refreshCacheIfNeeded();
        if (blockSearchDone) {
            return cachedBlockTarget;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            blockSearchDone = true;
            return null;
        }
        if (cachedVanillaHit != null && cachedVanillaHit.m_6662_() == HitResult.Type.BLOCK && (distance = cachedEyePos.m_82554_(Vec3.m_82512_((Vec3i)(blockHit = (BlockHitResult)cachedVanillaHit).m_82425_()))) <= cachedRange) {
            cachedBlockTarget = blockHit;
            blockSearchDone = true;
            return cachedBlockTarget;
        }
        cachedBlockTarget = CrosshairDetector.findBlockManual(mc);
        blockSearchDone = true;
        return cachedBlockTarget;
    }

    public static <T extends Block> BlockTarget<T> getTargetedBlockInfo(Class<T> blockClass) {
        BlockHitResult hit = CrosshairDetector.getTargetedBlockHit();
        if (hit == null || hit.m_6662_() != HitResult.Type.BLOCK) {
            return null;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return null;
        }
        BlockPos pos = hit.m_82425_();
        BlockState state = mc.f_91073_.m_8055_(pos);
        if (blockClass.isInstance(state.m_60734_())) {
            Block block = state.m_60734_();
            return new BlockTarget<Block>(pos, state, block, hit);
        }
        return null;
    }

    public static <T extends Entity> List<T> getNearbyEntities(Class<T> entityClass, double range, Predicate<T> validator) {
        CrosshairDetector.refreshCacheIfNeeded();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return List.of();
        }
        LocalPlayer player = mc.f_91074_;
        Vec3 playerPos = player.m_20182_();
        Vec3 eyePos = cachedEyePos;
        Vec3 lookVec = cachedLookVec;
        double rangeSq = range * range;
        AABB searchBox = new AABB(playerPos.f_82479_ - range, playerPos.f_82480_ - range, playerPos.f_82481_ - range, playerPos.f_82479_ + range, playerPos.f_82480_ + range, playerPos.f_82481_ + range);
        List candidates = mc.f_91073_.m_6443_(entityClass, searchBox, validator != null ? validator : e -> true);
        ArrayList<Entity> filtered = new ArrayList<Entity>();
        for (Entity entity : candidates) {
            Vec3 toEntity;
            double viewDot;
            Vec3 entityPos = entity.m_20182_();
            double distSq = entityPos.m_82557_(playerPos);
            if (distSq > rangeSq || (viewDot = (toEntity = entityPos.m_82546_(eyePos).m_82541_()).m_82526_(lookVec)) < -0.3) continue;
            filtered.add(entity);
        }
        filtered.sort((a, b) -> {
            boolean bInFront;
            Vec3 toA = a.m_20182_().m_82546_(eyePos).m_82541_();
            Vec3 toB = b.m_20182_().m_82546_(eyePos).m_82541_();
            double viewScoreA = toA.m_82526_(lookVec);
            double viewScoreB = toB.m_82526_(lookVec);
            boolean aInFront = viewScoreA > 0.7;
            boolean bl = bInFront = viewScoreB > 0.7;
            if (aInFront && !bInFront) {
                return -1;
            }
            if (bInFront && !aInFront) {
                return 1;
            }
            double distA = a.m_20238_(playerPos);
            double distB = b.m_20238_(playerPos);
            return Double.compare(distA, distB);
        });
        return filtered;
    }

    private static <T extends Entity> T findEntityManual(Minecraft mc, Class<T> typeFilter, Predicate<T> validator) {
        LocalPlayer player = mc.f_91074_;
        Vec3 eyePos = cachedEyePos;
        Vec3 lookVec = cachedLookVec;
        double maxRange = cachedRange;
        Vec3 endPos = eyePos.m_82549_(lookVec.m_82490_(maxRange));
        AABB searchBox = new AABB(eyePos, endPos).m_82400_(2.0);
        double closestDistSq = Double.MAX_VALUE;
        Entity closest = null;
        Class<Object> searchClass = typeFilter != null ? typeFilter : Entity.class;
        for (Entity entity : mc.f_91073_.m_45976_(searchClass, searchBox)) {
            double distSq;
            float entityRadius;
            double tolerance;
            double maxDeviationSq;
            Vec3 pointOnRay;
            double deviationSq;
            if (entity == player) continue;
            Entity typedEntity = entity;
            if (validator != null && !validator.test(typedEntity)) continue;
            AABB entityBox = entity.m_20191_();
            Optional intersection = entityBox.m_82371_(eyePos, endPos);
            if (intersection.isPresent()) {
                double distSq2 = eyePos.m_82557_((Vec3)intersection.get());
                if (!(distSq2 < closestDistSq)) continue;
                closestDistSq = distSq2;
                closest = typedEntity;
                continue;
            }
            Vec3 entityCenter = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0);
            Vec3 toEntity = entityCenter.m_82546_(eyePos);
            double projection = toEntity.m_82526_(lookVec);
            if (projection <= 0.0 || projection > maxRange || (deviationSq = entityCenter.m_82557_(pointOnRay = eyePos.m_82549_(lookVec.m_82490_(projection)))) > (maxDeviationSq = (tolerance = (double)(entityRadius = Math.max(entity.m_20205_() / 2.0f, entity.m_20206_() / 2.0f)) + 0.3) * tolerance) || !((distSq = toEntity.m_82556_()) < closestDistSq)) continue;
            closestDistSq = distSq;
            closest = typedEntity;
        }
        return (T)closest;
    }

    private static BlockHitResult findBlockManual(Minecraft mc) {
        Vec3 eyePos = cachedEyePos;
        Vec3 lookVec = cachedLookVec;
        double maxRange = cachedRange;
        Vec3 endPos = eyePos.m_82549_(lookVec.m_82490_(maxRange));
        ClipContext clipContext = new ClipContext(eyePos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)mc.f_91074_);
        BlockHitResult result = mc.f_91073_.m_45547_(clipContext);
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            return result;
        }
        return null;
    }

    private static void refreshCacheIfNeeded() {
        long currentFrame;
        Minecraft mc = Minecraft.m_91087_();
        long l = currentFrame = mc.f_91073_ != null ? mc.f_91073_.m_46467_() : 0L;
        if (currentFrame != lastCacheFrame) {
            lastCacheFrame = currentFrame;
            cachedVanillaHit = mc.f_91077_;
            cachedBlockTarget = null;
            blockSearchDone = false;
            if (mc.f_91074_ != null) {
                cachedEyePos = mc.f_91074_.m_146892_();
                cachedLookVec = mc.f_91074_.m_20154_();
                cachedRange = InsightConfig.getDetectionRange();
            } else {
                cachedEyePos = null;
                cachedLookVec = null;
                cachedRange = 0.0;
            }
        }
    }

    public record BlockTarget<T extends Block>(BlockPos pos, BlockState state, T block, BlockHitResult hitResult) {
    }
}

