/*
 * Decompiled with CFR 0.152.
 */
package com.chan1.client.feature.items;

import com.chan1.client.config.InsightConfig;
import com.chan1.client.feature.items.DroppedItemDetector;
import com.chan1.client.util.render.AnimationHelper;
import com.chan1.client.util.render.TooltipBackgroundRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public final class DroppedItemBillboardRenderer {
    private static final int LIGHT_FULL_BRIGHT = 0xF000F0;
    private static final float ICON_SIZE = 16.0f;
    private static final float ICON_PADDING = 2.0f;
    private static final int COUNT_COLOR = 0xBBBBBB;
    private static final float MAX_SCALE_MULTIPLIER = 1.0f;
    private static final float SCALE_START_DISTANCE = 3.0f;
    private static final AnimationHelper animationHelper = new AnimationHelper();

    private DroppedItemBillboardRenderer() {
    }

    public static void renderBillboards(class_4587 poseStack, class_4597 bufferSource, class_4184 camera, float partialTick) {
        class_1542 crosshairItem;
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 == null || minecraft.field_1687 == null || minecraft.field_1755 != null) {
            return;
        }
        List<Object> items = InsightConfig.getDetectionMode() == InsightConfig.DetectionMode.CROSSHAIR ? ((crosshairItem = DroppedItemDetector.getCrosshairItem()) != null ? List.of(crosshairItem) : List.of()) : DroppedItemDetector.getNearbyItems();
        class_243 cameraPos = camera.method_19326();
        class_243 cameraLookVec = new class_243(camera.method_19335());
        ArrayList<ItemWithDistance> sortedItems = new ArrayList<ItemWithDistance>();
        for (Object itemEntity : items) {
            class_243 itemPos = DroppedItemBillboardRenderer.getInterpolatedPosition((class_1542)itemEntity, partialTick);
            class_243 toItem = itemPos.method_1020(cameraPos);
            double distance = toItem.method_1033();
            if (toItem.method_1029().method_1026(cameraLookVec) < -0.2) continue;
            sortedItems.add(new ItemWithDistance((class_1542)itemEntity, distance, itemPos));
        }
        HashSet<Integer> currentEntityIds = new HashSet<Integer>();
        for (ItemWithDistance item : sortedItems) {
            currentEntityIds.add(item.entity().method_5628());
        }
        animationHelper.cleanupStaleAnimations(currentEntityIds);
        if (sortedItems.isEmpty()) {
            return;
        }
        sortedItems.sort(Comparator.comparingDouble(ItemWithDistance::distance).reversed());
        if (bufferSource instanceof class_4597.class_4598) {
            class_4597.class_4598 source = (class_4597.class_4598)bufferSource;
            source.method_22993();
        }
        if (InsightConfig.isAnimationsEnabled()) {
            for (ItemWithDistance item : sortedItems) {
                animationHelper.getOrCreateAppearAnimation(item.entity().method_5628());
            }
        }
        for (ItemWithDistance item : sortedItems) {
            AnimationHelper.AnimationState state;
            float animScale = 1.0f;
            if (InsightConfig.isAnimationsEnabled() && (state = animationHelper.getAnimationState(item.entity().method_5628())) != null) {
                animScale = AnimationHelper.calculateScale(state, InsightConfig.getAnimationDurationMs());
            }
            if (!(animScale > 0.001f)) continue;
            DroppedItemBillboardRenderer.renderItemBillboard(poseStack, bufferSource, item.entity(), item.position(), item.distance(), cameraPos, camera, minecraft.field_1772, animScale);
        }
    }

    private static void renderItemBillboard(class_4587 poseStack, class_4597 bufferSource, class_1542 itemEntity, class_243 itemPos, double distance, class_243 cameraPos, class_4184 camera, class_327 font, float animScale) {
        class_310 minecraft = class_310.method_1551();
        if (distance > InsightConfig.getMaxRenderDistance()) {
            return;
        }
        float alpha = 1.0f;
        class_1799 itemStack = itemEntity.method_6983();
        int stackCount = itemStack.method_7947();
        class_2561 titleLine = DroppedItemBillboardRenderer.buildTitleWithCount(itemStack, stackCount);
        List originalTooltip = itemStack.method_7950((class_1657)minecraft.field_1724, (class_1836)(minecraft.field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070));
        if (originalTooltip.isEmpty()) {
            return;
        }
        class_243 billboardPos = itemPos.method_1031(0.0, InsightConfig.getTooltipYOffset(), 0.0);
        float iconTotalWidth = 20.0f;
        int maxTextWidth = font.method_27525((class_5348)titleLine);
        for (int i = 1; i < originalTooltip.size(); ++i) {
            int width = font.method_27525((class_5348)originalTooltip.get(i));
            if (width <= maxTextWidth) continue;
            maxTextWidth = width;
        }
        int textAreaWidth = maxTextWidth + 6;
        int tooltipWidth = (int)iconTotalWidth + textAreaWidth;
        int tooltipHeight = 4 + originalTooltip.size() * 10;
        if (originalTooltip.size() > 1) {
            ++tooltipHeight;
        }
        tooltipHeight = Math.max(tooltipHeight, 18);
        poseStack.method_22903();
        poseStack.method_22904(billboardPos.field_1352 - cameraPos.field_1352, billboardPos.field_1351 - cameraPos.field_1351, billboardPos.field_1350 - cameraPos.field_1350);
        Quaternionf cameraRotation = camera.method_23767();
        poseStack.method_22907(cameraRotation);
        float baseScale = InsightConfig.getBillboardScale();
        float distanceScale = DroppedItemBillboardRenderer.calculateDistanceScale(distance);
        float scale = baseScale * distanceScale * animScale;
        poseStack.method_22905(-scale, -scale, scale);
        float halfWidth = (float)tooltipWidth / 2.0f;
        float halfHeight = (float)tooltipHeight / 2.0f;
        Matrix4f matrix = poseStack.method_23760().method_23761();
        float left = -halfWidth - 3.0f;
        float top = -halfHeight - 3.0f;
        float right = halfWidth + 3.0f;
        float bottom = halfHeight + 3.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        TooltipBackgroundRenderer.renderNoStateChange(matrix, left, top, right, bottom, alpha);
        DroppedItemBillboardRenderer.renderItemIconNoStateChange(poseStack, bufferSource, itemStack, -halfWidth + 2.0f, -8.0f, alpha);
        int textAlpha = (int)(255.0f * alpha);
        float textStartX = -halfWidth + iconTotalWidth + 2.0f;
        float y = -halfHeight + 2.0f;
        class_4597.class_4598 immediateSource = minecraft.method_22940().method_23000();
        font.method_30882(titleLine, textStartX, y, textAlpha << 24 | 0xFFFFFF, false, matrix, (class_4597)immediateSource, class_327.class_6415.field_33994, 0, 0xF000F0);
        y += 10.0f;
        if (originalTooltip.size() > 1) {
            y += 1.0f;
        }
        for (int i = 1; i < originalTooltip.size(); ++i) {
            class_2561 line = (class_2561)originalTooltip.get(i);
            font.method_30882(line, textStartX, y, textAlpha << 24 | 0xAAAAAA, false, matrix, (class_4597)immediateSource, class_327.class_6415.field_33994, 0, 0xF000F0);
            y += 10.0f;
        }
        immediateSource.method_22993();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        poseStack.method_22909();
    }

    private static class_2561 buildTitleWithCount(class_1799 itemStack, int count) {
        class_5250 name = itemStack.method_7964().method_27661();
        if (count > 1) {
            class_5250 countText = class_2561.method_43470((String)(" x" + count)).method_27696(class_2583.field_24360.method_36139(0xBBBBBB));
            return name.method_10852((class_2561)countText);
        }
        return name;
    }

    private static void renderItemIcon(class_4587 poseStack, class_4597 bufferSource, class_1799 itemStack, float x, float y, float alpha) {
        class_310 minecraft = class_310.method_1551();
        class_918 itemRenderer = minecraft.method_1480();
        poseStack.method_22903();
        poseStack.method_46416(x + 8.0f, y + 8.0f, -0.01f);
        float iconScale = 14.0f;
        poseStack.method_22905(iconScale, -iconScale, 0.001f);
        poseStack.method_23760().method_23762().identity();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableDepthTest();
        class_4597.class_4598 immediateSource = minecraft.method_22940().method_23000();
        itemRenderer.method_23178(itemStack, class_811.field_4317, 0xF000F0, class_4608.field_21444, poseStack, (class_4597)immediateSource, (class_1937)minecraft.field_1687, 0);
        immediateSource.method_22993();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        poseStack.method_22909();
    }

    private static void renderItemIconNoStateChange(class_4587 poseStack, class_4597 bufferSource, class_1799 itemStack, float x, float y, float alpha) {
        class_310 minecraft = class_310.method_1551();
        class_918 itemRenderer = minecraft.method_1480();
        poseStack.method_22903();
        poseStack.method_46416(x + 8.0f, y + 8.0f, -0.01f);
        float iconScale = 14.0f;
        poseStack.method_22905(iconScale, -iconScale, 0.001f);
        poseStack.method_23760().method_23762().identity();
        class_4597.class_4598 immediateSource = minecraft.method_22940().method_23000();
        itemRenderer.method_23178(itemStack, class_811.field_4317, 0xF000F0, class_4608.field_21444, poseStack, (class_4597)immediateSource, (class_1937)minecraft.field_1687, 0);
        immediateSource.method_22993();
        poseStack.method_22909();
    }

    private static class_243 getInterpolatedPosition(class_1542 entity, float partialTick) {
        double x = entity.field_6014 + (entity.method_23317() - entity.field_6014) * (double)partialTick;
        double y = entity.field_6036 + (entity.method_23318() - entity.field_6036) * (double)partialTick;
        double z = entity.field_5969 + (entity.method_23321() - entity.field_5969) * (double)partialTick;
        return new class_243(x, y, z);
    }

    private static float calculateDistanceScale(double distance) {
        if (distance <= 3.0) {
            return 1.0f;
        }
        float maxDist = (float)InsightConfig.getMaxRenderDistance();
        float t = (float)(distance - 3.0) / (maxDist - 3.0f);
        t = Math.min(1.0f, Math.max(0.0f, t));
        return 1.0f + t * 0.5f;
    }

    public static void clearAnimations() {
        animationHelper.clear();
    }

    private record ItemWithDistance(class_1542 entity, double distance, class_243 position) {
    }
}

