/*
 * Decompiled with CFR 0.152.
 */
package com.chan1.client.feature.misc;

import com.chan1.client.config.InsightConfig;
import com.chan1.client.feature.misc.BedBlockDetector;
import com.chan1.client.util.MinecraftTimeHelper;
import com.chan1.client.util.render.TooltipBackgroundRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public final class BedTimerRenderer {
    private static final int LIGHT_FULL_BRIGHT = 0xF000F0;
    private static final float MIN_READABLE_SCALE = 0.65f;
    private static final float OPTIMAL_SCALE = 0.85f;
    private static final int ZZZ_COLOR = -6710785;

    public static void renderBillboards(class_4587 poseStack, class_4597 bufferSource, class_4184 camera, float partialTick) {
        boolean isNight;
        if (!InsightConfig.isBedTimerEnabled()) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 == null || minecraft.field_1687 == null || minecraft.field_1755 != null) {
            return;
        }
        class_2338 bedPos = BedBlockDetector.getTargetedBedPos();
        if (bedPos == null) {
            return;
        }
        class_243 billboardPos = BedBlockDetector.getBedBillboardPosition(bedPos);
        class_243 cameraPos = camera.method_19326();
        class_243 toBed = billboardPos.method_1020(cameraPos);
        double distance = toBed.method_1033();
        class_243 cameraLookVec = new class_243(camera.method_19335());
        if (toBed.method_1029().method_1026(cameraLookVec) < -0.2) {
            return;
        }
        if (distance > InsightConfig.getMaxRenderDistance()) {
            return;
        }
        if (bufferSource instanceof class_4597.class_4598) {
            class_4597.class_4598 source = (class_4597.class_4598)bufferSource;
            source.method_22993();
        }
        if (isNight = MinecraftTimeHelper.isNightTime(minecraft.field_1687)) {
            BedTimerRenderer.renderNightZzz(poseStack, billboardPos, distance, cameraPos, camera, minecraft.field_1772);
        } else {
            String timeText = MinecraftTimeHelper.formatTimeUntilNight(minecraft.field_1687);
            if (timeText != null) {
                BedTimerRenderer.renderDayTooltip(poseStack, billboardPos, distance, cameraPos, camera, minecraft.field_1772, timeText);
            }
        }
    }

    private static void renderDayTooltip(class_4587 poseStack, class_243 billboardPos, double distance, class_243 cameraPos, class_4184 camera, class_327 font, String timeText) {
        class_310 minecraft = class_310.method_1551();
        int textWidth = font.method_1727(timeText);
        int tooltipWidth = textWidth + 12;
        int tooltipHeight = 16;
        poseStack.method_22903();
        poseStack.method_22904(billboardPos.field_1352 - cameraPos.field_1352, billboardPos.field_1351 - cameraPos.field_1351, billboardPos.field_1350 - cameraPos.field_1350);
        Quaternionf cameraRotation = camera.method_23767();
        poseStack.method_22907(cameraRotation);
        float baseScale = InsightConfig.getBillboardScale();
        float distanceScale = BedTimerRenderer.calculateDistanceScale(distance);
        float scale = baseScale * distanceScale;
        poseStack.method_22905(-scale, -scale, scale);
        float halfWidth = (float)tooltipWidth / 2.0f;
        float halfHeight = (float)tooltipHeight / 2.0f;
        Matrix4f matrix = poseStack.method_23760().method_23761();
        float left = -halfWidth - 3.0f;
        float top = -halfHeight - 3.0f;
        float right = halfWidth + 3.0f;
        float bottom = halfHeight + 3.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        TooltipBackgroundRenderer.renderNoStateChange(matrix, left, top, right, bottom, 1.0f);
        class_4597.class_4598 immediateSource = minecraft.method_22940().method_23000();
        float textX = (float)(-textWidth) / 2.0f;
        Objects.requireNonNull(font);
        float textY = (float)(-9) / 2.0f;
        font.method_27521(timeText, textX, textY, -1, false, matrix, (class_4597)immediateSource, class_327.class_6415.field_33994, 0, 0xF000F0);
        immediateSource.method_22993();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        poseStack.method_22909();
    }

    private static void renderNightZzz(class_4587 poseStack, class_243 billboardPos, double distance, class_243 cameraPos, class_4184 camera, class_327 font) {
        class_310 minecraft = class_310.method_1551();
        long gameTime = minecraft.field_1687 != null ? minecraft.field_1687.method_8510() : 0L;
        float time = (float)(gameTime % 40L) / 40.0f * (float)Math.PI * 2.0f;
        int zWidth = font.method_1727("z");
        float charSpacing = zWidth + 2;
        float totalWidth = charSpacing * 3.0f - 2.0f;
        poseStack.method_22903();
        float floatOffset = (float)Math.sin(time * 0.5f) * 3.0f;
        poseStack.method_22904(billboardPos.field_1352 - cameraPos.field_1352, billboardPos.field_1351 - cameraPos.field_1351, billboardPos.field_1350 - cameraPos.field_1350);
        Quaternionf cameraRotation = camera.method_23767();
        poseStack.method_22907(cameraRotation);
        float baseScale = InsightConfig.getBillboardScale();
        float distanceScale = BedTimerRenderer.calculateDistanceScale(distance);
        float scale = baseScale * distanceScale;
        float pulseScale = 1.0f + (float)Math.sin(time * 0.7f) * 0.05f;
        poseStack.method_22905(-(scale *= pulseScale), -scale, scale);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        class_4597.class_4598 immediateSource = minecraft.method_22940().method_23000();
        float startX = -totalWidth / 2.0f;
        for (int i = 0; i < 3; ++i) {
            float phaseOffset = (float)i * 0.8f;
            float waveY = (float)Math.sin(time + phaseOffset) * 4.0f;
            float sizeMultiplier = 1.0f + (float)i * 0.15f;
            int alpha = 255 - i * 25;
            int color = alpha << 24 | 0x9999FF;
            poseStack.method_22903();
            float charX = startX + (float)i * charSpacing;
            Objects.requireNonNull(font);
            float charY = (float)(-9) / 2.0f + waveY + floatOffset;
            if (sizeMultiplier != 1.0f) {
                float f = charX + (float)zWidth / 2.0f;
                Objects.requireNonNull(font);
                poseStack.method_46416(f, charY + 9.0f / 2.0f, 0.0f);
                poseStack.method_22905(sizeMultiplier, sizeMultiplier, 1.0f);
                float f2 = -(charX + (float)zWidth / 2.0f);
                Objects.requireNonNull(font);
                poseStack.method_46416(f2, -(charY + 9.0f / 2.0f), 0.0f);
            }
            Matrix4f matrix = poseStack.method_23760().method_23761();
            font.method_27521("z", charX, charY, color, false, matrix, (class_4597)immediateSource, class_327.class_6415.field_33994, 0, 0xF000F0);
            poseStack.method_22909();
        }
        immediateSource.method_22993();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        poseStack.method_22909();
    }

    private static float calculateDistanceScale(double distance) {
        float maxDist = (float)InsightConfig.getMaxRenderDistance();
        if (distance <= 1.5) {
            float t = (float)(distance / 1.5);
            return 0.65f + t * 0.20000005f * 0.5f;
        }
        if (distance <= 4.0) {
            float t = (float)((distance - 1.5) / 2.5);
            float startScale = 0.75f;
            return startScale + t * (0.85f - startScale);
        }
        float t = (float)((distance - 4.0) / ((double)maxDist - 4.0));
        t = Math.min(1.0f, Math.max(0.0f, t));
        return 0.85f + t * 0.25f;
    }
}

