/*
 * Decompiled with CFR 0.152.
 */
package com.chan1.client.feature.misc;

import com.chan1.client.config.InsightConfig;
import com.chan1.client.util.detection.CrosshairDetector;
import net.minecraft.class_2242;
import net.minecraft.class_2248;
import net.minecraft.class_2282;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2421;
import net.minecraft.class_243;
import net.minecraft.class_2513;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3830;
import net.minecraft.class_3965;

public final class CropGrowthDetector {
    public static CropInfo getTargetedCropInfo() {
        class_3965 blockHit = CrosshairDetector.getTargetedBlockHit();
        if (blockHit == null || blockHit.method_17783() != class_239.class_240.field_1332) {
            return null;
        }
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 == null) {
            return null;
        }
        class_2338 pos = blockHit.method_17777();
        class_2680 state = minecraft.field_1687.method_8320(pos);
        return CropGrowthDetector.getCropInfo(pos, state);
    }

    private static CropInfo getCropInfo(class_2338 pos, class_2680 state) {
        class_2248 block = state.method_26204();
        if (block instanceof class_2302) {
            class_2302 crop = (class_2302)block;
            int age = crop.method_9829(state);
            int maxAge = crop.method_9827();
            String name = CropGrowthDetector.getCropName(block);
            return new CropInfo(pos, name, age, maxAge, age >= maxAge);
        }
        if (block instanceof class_2242) {
            int maxAge;
            int age;
            return new CropInfo(pos, "Beetroot", age, maxAge, (age = ((Integer)state.method_11654((class_2769)class_2242.field_9962)).intValue()) >= (maxAge = 3));
        }
        if (block instanceof class_2421) {
            int maxAge;
            int age;
            return new CropInfo(pos, "Nether Wart", age, maxAge, (age = ((Integer)state.method_11654((class_2769)class_2421.field_11306)).intValue()) >= (maxAge = 3));
        }
        if (block instanceof class_2513) {
            int age = (Integer)state.method_11654((class_2769)class_2513.field_11584);
            int maxAge = 7;
            String name = block.method_9518().getString();
            return new CropInfo(pos, name, age, maxAge, age >= maxAge);
        }
        if (block instanceof class_3830) {
            int maxAge;
            int age;
            return new CropInfo(pos, "Sweet Berries", age, maxAge, (age = ((Integer)state.method_11654((class_2769)class_3830.field_17000)).intValue()) >= (maxAge = 3));
        }
        if (block instanceof class_2282) {
            int maxAge;
            int age;
            return new CropInfo(pos, "Cocoa", age, maxAge, (age = ((Integer)state.method_11654((class_2769)class_2282.field_10779)).intValue()) >= (maxAge = 2));
        }
        return null;
    }

    private static String getCropName(class_2248 block) {
        String name = block.method_9518().getString();
        if (name.toLowerCase().contains("wheat")) {
            return "Wheat";
        }
        if (name.toLowerCase().contains("carrot")) {
            return "Carrots";
        }
        if (name.toLowerCase().contains("potato")) {
            return "Potatoes";
        }
        return name;
    }

    public static class_243 getCropBillboardPosition(class_2338 cropPos) {
        return class_243.method_24953((class_2382)cropPos).method_1031(0.0, 0.1 + InsightConfig.getTooltipYOffset(), 0.0);
    }

    public record CropInfo(class_2338 pos, String cropName, int currentAge, int maxAge, boolean isFullyGrown) {
        public float getGrowthPercent() {
            if (this.maxAge == 0) {
                return 100.0f;
            }
            return (float)this.currentAge / (float)this.maxAge * 100.0f;
        }
    }
}

